/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.session;

import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYvalues;

/**
 * @author EH076
 *
 */
public class HubConfig {

    /**
     * Hub ID value for RSW hub.
     */
    public static final String HUBID_RSW = "1990000035";
    public static final String APPID_RSW = "";
    /**
     * Hub ID value for VZNKUL hub.
     */
    public static final String HUBID_VZNKUL = "1990000827";
    public static final String APPID_VZNKUL = "";
    /**
     * Hub ID value for COZO hub.
     */
    public static final String HUBID_COZO = "1990000134";
    public static final String APPID_COZO = "TST2015";
    /**
     * Hub ID value for ARH hub.
     */
    public static final String HUBID_ARH = "1990000233";
    public static final String APPID_ARH = "";
    /**
     * URL to contact for RSW hub.
     */
    public static final String URL_RSW = "https://hub.reseausantewallon.be/standards/hubservices/intrahub/intrahubservice.asmx";
    /**
     * URL to contact for VZNKUL hub.
     */
    public static final String URL_VZNKUL = "https://hubacc.vznkul.be/services/acceptance/intrahub/IntraHubService";
    /**
     * URL to contact for COZO hub.
     */
    public static final String URL_COZO = "https://servicestest.cozo.be/IntrahubServiceTest/service.asmx";
    /**
     * URL to contact for ARH hub.
     */
    public static final String URL_ARH = "https://test.antwerpseregionalehub.be/IntrahubService/service.asmx?wsdl";
    protected static final String HUB_ID = "hub.id";
    protected static final String HUB_APP = "hub.application";
    protected static final String ENDPOINT_HUB_INTRA = "endpoint.hub.intra";
    /*
     * Patient Informations
     */
    protected static final String PATIENT_INSS = "91121208397";
    protected static final String PATIENT_CARDNO = "591559638269";
    protected static final String PATIENT_FIRSTNAME = "Guillaume";
    protected static final String PATIENT_LASTNAME = "Strauven";
    /*
     * Professional Information The nihii is found in the session
     */
    protected static final String PROF_INSS = "82051234978";
    protected static final String PROF_FIRSTNAME = "Hannes";
    protected static final String PROF_LASTNAME = "De Clercq";
    protected static final String PROF_PROFESSION = CDHCPARTYvalues.PERSPHYSICIAN.value();
//    protected static final String CHOSENHUB_NAME = "VZN_KUL";
//    protected static final String CHOSENHUB_ID = HUBID_VZNKUL;
//    protected static final String CHOSENHUB_URL = URL_VZNKUL;
//    protected static final String CHOSENHUB_NAME = "COZO";
//    protected static final String CHOSENHUB_ID = HUBID_COZO;
//    protected static final String CHOSENHUB_URL = URL_COZO;
    protected static final String CHOSENHUB_NAME = "RSW";
    protected static final String CHOSENHUB_ID = HUBID_RSW;
    protected static final String CHOSENHUB_URL = URL_RSW;
    protected static final String MESSAGE_ID = "1";
    protected static final String SV_ID = "1.0";
    protected static final String SV_CD = "1.0";

}
