/*
 * Copyright (c) Smals
 */
package be.ehealth.business.mycarenetcommons.mappers;

import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;

import be.ehealth.business.mycarenetcommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetcommons.builders.impl.BlobBuilderImpl;
import be.ehealth.business.mycarenetcommons.domain.Blob;
import be.ehealth.business.mycarenetcommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetcommons.mapper.SendRequestMapper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;


/**
 * tests the mapping between myCarenet and genAsync objects.
 * 
 * @author EHP
 * 
 */

public class SendRequestMapperTest {

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.genericasync.mappers.BlobMapper#mapBlob(be.ehealth.business.mycarenetcommons.domain.Blob)}
     * .
     * 
     * @throws TechnicalConnectorException
     * @throws InvalidBlobContentConnectorException
     */
    @Test
    public void testMapBlob() throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        BlobBuilder myCarenetBlobBuilder = new BlobBuilderImpl();
        String contentType = "text/someContentType";
        String id = "blobIdentifier";
        String encodingType = "deflate";
        byte[] bytes = "azerty".getBytes();
        Blob myCarenetBlob = myCarenetBlobBuilder.build(bytes, encodingType, id, contentType);
        String messageName = "someMessageName";
        myCarenetBlob.setMessageName(messageName);
        be.cin.types.v1.Blob mappedBlob = SendRequestMapper.mapBlobToCinBlob(myCarenetBlob);
        be.cin.types.v1.Blob expected = new be.cin.types.v1.Blob();

        expected.setContentEncoding(encodingType);
        expected.setContentType(contentType);
        expected.setId(id);
        expected.setMessageName(messageName);
        expected.setValue(null);
        ReflectionAssert.assertLenientEquals(expected, mappedBlob);

        Blob returnedBlob = SendRequestMapper.mapToBlob(mappedBlob);
        myCarenetBlob.setMessageName(null);
        ReflectionAssert.assertLenientEquals(myCarenetBlob, returnedBlob);
    }

}
