/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genins.mapper;

import org.junit.Test;

import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.business.mycarenetcommons.domain.CommonInput;
import be.ehealth.business.mycarenetcommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetcommons.domain.Nihii;
import be.ehealth.business.mycarenetcommons.domain.Origin;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.genericinsurability.core.v1.CommonInputType;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;


/**
 * Test of the common input mapper
 * 
 * @author EHP
 * 
 */
public class CommonInputMapperTest {


    @Test
    public void testCommonInputMapping() throws Exception {
        MarshallerHelper<CommonInputType, CommonInputType> helper = new MarshallerHelper<CommonInputType, CommonInputType>(CommonInputType.class, CommonInputType.class);
        CommonInputType commonInputExample = helper.toObject(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/commonInput-genins.xml")));

        Boolean istest = commonInputExample.getRequest().isIsTest();
        String ref = new String(commonInputExample.getInputReference());
        Nihii nihii = new Nihii(commonInputExample.getOrigin().getCareProvider().getNihii().getQuality(), commonInputExample.getOrigin().getCareProvider().getNihii().getValue().getValue());
        CareProvider careProvider = new CareProvider(nihii);
        Origin origin = new Origin(new McnPackageInfo(commonInputExample.getOrigin().getPackage().getLicense().getUsername(), commonInputExample.getOrigin().getPackage().getLicense().getPassword(), commonInputExample.getOrigin().getPackage().getName().getValue()), careProvider);
        CommonInput input = new CommonInput(istest, origin, ref);
        CommonInputType output = CommonInputMapper.mapCommonInput(input);

        XmlAsserter.assertSimilar(commonInputExample, output);
    }
}
