/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import java.util.Properties;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.mycarenetcommons.builders.CommonBuilder;
import be.ehealth.business.mycarenetcommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetcommons.domain.CommonInput;
import be.ehealth.business.mycarenetcommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetcommons.domain.Routing;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * Test class for Commonb
 * 
 * @author EHP
 * 
 */
public class CommonBuilderTest extends AbstractCommonBuilderImplTest {

    @Test
    public void testCreateCommonRequestWithDeprecatedPackageInfo() throws Exception {

        SessionInitializer.init("/be.ehealth.businessconnector.mycarenetcommons.test.properties", false);
        CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder("mycarenetcommons");
        PackageInfo packageInfo = new PackageInfo("userName", "password", "mycarenetcommons");
        CommonInput commonInput = commonBuilder.createCommonInput(packageInfo, false, "inputReference");
        Assert.assertEquals(commonInput.getInputReference(), "inputReference");
        Assert.assertEquals(commonInput.getOrigin().getSiteId(), null);

        // if professionType begins with pers -> careprovider nihii should also be the session nihii
        Properties testProps = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.mycarenetcommons.test.properties");
        String professionType = testProps.getProperty("session.professionType");
        if (professionType != null && professionType.startsWith("pers")) {
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getNihii().getValue(), SessionUtil.getNihii11());
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getOrganization(), null);
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getCbe(), null);
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getName(), SessionUtil.getFullName());
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getSsin(), SessionUtil.getNiss());
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getNihii(), null);
        }
        // in theory we need to add the sender , but this is not supported for genins , and de facto optionall for the rest ( spec MyCareNet
        // Authentication Catalogue 4.1.1 )
        // in our property files we will not add the sender at the moment
        // Assert.assertEquals(commonInput.getOrigin().getSender().getPhysicalPerson().getSsin(), SessionUtil.getNiss());

        Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getCbe(), null);
        Assert.assertNotNull(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getName());
        Assert.assertNotNull(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getSsin());
        Assert.assertEquals(commonInput.getOrigin().getPackageInfo().getPackageName(), packageInfo.getPackageName());
        Assert.assertEquals(commonInput.getOrigin().getPackageInfo().getPassword(), packageInfo.getPassword());
        Assert.assertEquals(commonInput.getOrigin().getPackageInfo().getUserName(), packageInfo.getUserName());
        Session.getInstance().unloadSession();
    }
    
    
    @Test
    public void testCreateCommonRequest() throws Exception {

        SessionInitializer.init("/be.ehealth.businessconnector.mycarenetcommons.test.properties", false);
        CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder("mycarenetcommons");
        McnPackageInfo packageInfo = new McnPackageInfo("userName", "password", "mycarenetcommons");
        CommonInput commonInput = commonBuilder.createCommonInput(packageInfo, false, "inputReference");
        Assert.assertEquals(commonInput.getInputReference(), "inputReference");
        Assert.assertEquals(commonInput.getOrigin().getSiteId(), null);

        // if professionType begins with pers -> careprovider nihii should also be the session nihii
        Properties testProps = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.mycarenetcommons.test.properties");
        String professionType = testProps.getProperty("session.professionType");
        if (professionType != null && professionType.startsWith("pers")) {
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getNihii().getValue(), SessionUtil.getNihii11());
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getOrganization(), null);
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getCbe(), null);
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getName(), SessionUtil.getFullName());
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getSsin(), SessionUtil.getNiss());
            Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getNihii(), null);
        }
        // in theory we need to add the sender , but this is not supported for genins , and de facto optionall for the rest ( spec MyCareNet
        // Authentication Catalogue 4.1.1 )
        // in our property files we will not add the sender at the moment
        // Assert.assertEquals(commonInput.getOrigin().getSender().getPhysicalPerson().getSsin(), SessionUtil.getNiss());

        Assert.assertEquals(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getCbe(), null);
        Assert.assertNotNull(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getName());
        Assert.assertNotNull(commonInput.getOrigin().getCareProvider().getPhysicalPerson().getSsin());
        Assert.assertEquals(commonInput.getOrigin().getMcnPackageInfo().getPackageName(), packageInfo.getPackageName());
        Assert.assertEquals(commonInput.getOrigin().getMcnPackageInfo().getPassword(), packageInfo.getPassword());
        Assert.assertEquals(commonInput.getOrigin().getMcnPackageInfo().getUserName(), packageInfo.getUserName());
        // test that old deprecated methods still work
        Assert.assertEquals(commonInput.getOrigin().getPackageInfo().getPackageName(), packageInfo.getPackageName());
        Assert.assertEquals(commonInput.getOrigin().getPackageInfo().getPassword(), packageInfo.getPassword());
        Assert.assertEquals(commonInput.getOrigin().getPackageInfo().getUserName(), packageInfo.getUserName());
        Session.getInstance().unloadSession();
    }

    @Test
    public void testRoutingBuilder() throws Exception {
        Patient patient = new Patient();
        patient.setEidCardNumber("");
        patient.setFirstName("");
        patient.setLastName("");
        patient.setInss("");
        patient.setMutuality(null);
        patient.setRegNrWithMut(null);
        DateTime refDate = new DateTime();
        Routing routing = RequestBuilderFactory.getCommonBuilder("mycarenetcommons").createRouting(patient, refDate);

        Assert.assertEquals(routing.getCareReceiver().getMutuality(), null);
        Assert.assertEquals(routing.getCareReceiver().getRegistrationNumberWithMutuality(), null);
        Assert.assertEquals(routing.getCareReceiver().getSsinNumber(), patient.getInss());
        Assert.assertEquals(routing.getReferenceDate(), refDate);
        Assert.assertNull(routing.getPeriod());
    }

}
