/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap.generator;

import org.dozer.classmap.ClassMap;
import org.dozer.classmap.Configuration;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.util.MappingUtils;

public final class GeneratorUtils {
    private static final String CLASS = "class";
    private static final String CALLBACK = "callback";
    private static final String CALLBACKS = "callbacks";

    private GeneratorUtils() {
    }

    public static boolean shouldIgnoreField(String fieldName, Class<?> srcType, Class<?> destType) {
        if (CLASS.equals(fieldName)) {
            return true;
        }
        return !(!CALLBACK.equals(fieldName) && !CALLBACKS.equals(fieldName) || !MappingUtils.isProxy(srcType) && !MappingUtils.isProxy(destType));
    }

    public static void addGenericMapping(ClassMap classMap, Configuration configuration, String srcName, String destName) {
        GenericFieldMap fieldMap = new GenericFieldMap(classMap);
        fieldMap.setSrcField(new DozerField(srcName, null));
        fieldMap.setDestField(new DozerField(destName, null));
        MappingUtils.applyGlobalCopyByReference(configuration, fieldMap, classMap);
        classMap.addFieldMapping(fieldMap);
    }
}

