﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using java.io;

using be.ehealth.businessconnector.chapterIV.builders;
using be.ehealth.businessconnector.chapterIV.exception;
using be.ehealth.businessconnector.chapterIV.session;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.core.v1;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.chapterIV.integration
{
	[TestFixture]
	public class AbstractChapterIV
	{
		
		private static ResponseBuilder responseBuilder;



		[SetUp]
		public static void setup(){
			SessionInitializer.init(".\\be.ehealth.businessconnector.chapterIV.test.properties", SupportedLanguages.NET.getAbbreviation());
			responseBuilder = BuilderFactory.getBuilderFactoryForSession().getResponseBuilder();
		}

		/**
		 * @param service
		 * @param e
		 */
		protected void processChapterIvBusinessException(ChapterIVService service, ChapterIVBusinessConnectorException e) {
			java.lang.StringBuilder sb = new java.lang.StringBuilder();
			appendAndLog(sb, e.getMessage());
			appendAndLog(sb, e.getMessage());

			SOAErrorType soaError = e.getSOAError();
			if (soaError != null) {
				String errorCode = soaError.getCode();
				appendAndLog(sb, "ChapterIVIntegrationTest.test" + service + "Request: error : " + errorCode);
				appendAndLog(sb, "contact :" + soaError.getContact());
				appendAndLog(sb, "environment : " + soaError.getEnvironment());
				appendAndLog(sb, "id :" + soaError.getId());
				appendAndLog(sb, "Origin " + soaError.getOrigin());
				appendAndLog(sb, "isRetrye : " + soaError.isRetry());
				java.util.List list = soaError.getMessages();
				for (int i = 0; i<list.size();i++){
					LocalisedStringType localisedString = (LocalisedStringType)list.get(i);
					appendAndLog(sb, "message : lang=" + localisedString.getLang() + " and value = " + localisedString.getValue());
				}
			}
			Assert.Fail(sb.toString());
		}

		/**
		 * @param e
		 */
		protected void processError(SoaErrorException e, String service) {
			java.lang.StringBuilder sb = new java.lang.StringBuilder();
			String errorCode = e.getErrorCode();
			appendAndLog(sb, "ChapterIVIntegrationTest.test" + service + "Request: error : " + errorCode);
			FaultType fault = responseBuilder.retrieveReturnInfo(e.getResponseType());
			String errorMessage = "";
			if (fault.getMessage() != null) {
				errorMessage = fault.getMessage().getValue();
			}
			appendAndLog(sb, "errorMessage :" + errorMessage);
			java.util.List list = fault.getDetails();
			for (int i = 0; i<list.size(); i++) {
				DetailType detail = (DetailType)list.get(i);
				appendAndLog(sb, "detail : " + detail.getDetailCode() + " " + detail.getDetailSource() + " " + detail.getLocation() + " " + (detail.getMessage() == null ? "no messages" : detail.getMessage().getValue()));
			}
			Assert.Fail(sb.toString());
		}

		/**
		 * @param xmlResourceInputStream
		 * @return
		 * @throws TechnicalConnectorException
		 */
		protected FolderType parseFolderType(InputStream xmlResourceInputStream) {
			MarshallerHelper folderTypeMarshaller = new MarshallerHelper(typeof(FolderType), typeof(FolderType));
			return (FolderType)folderTypeMarshaller.toObject(xmlResourceInputStream);
		}

		/**
		 * @param sb
		 * @param message
		 */
		protected void appendAndLog(java.lang.StringBuilder sb, String message) {
			System.Console.WriteLine(message);
			sb.append(message).append("\n");
		}


		/**
		 * @return the responseBuilder
		 */
		public static ResponseBuilder getResponseBuilder() {
			return responseBuilder;
		}

		/**
		 * @return
		 */
		protected static bool isDoctor() {
			java.util.List result = SAMLTokenUtils.getAttributeValue(Session.getInstance().getSession().getSAMLToken().getAssertion(), "doctor");
			return !result.isEmpty();
		}
	}
}
