﻿/*
 * Copyright (c) eHealth
 */
using System;

using System.Collections.Generic;

namespace be.ehealth.businessconnector.therlink.util
{

    /**
     * Associations between hcparty types and therapeutic link types
     * 
     * @author EHP
     * 
     */
    public class TherapeuticLinkTypeValues
    {
        public static readonly TherapeuticLinkTypeValues PERSNURSE = new TherapeuticLinkTypeValues("persnurse", "nurseconsultation", "nursereferral");
        public static readonly TherapeuticLinkTypeValues PERSPHYSICIAN= new TherapeuticLinkTypeValues("persphysician", "gpconsultation", "gpreferral");
        public static readonly TherapeuticLinkTypeValues DEPTPHARMACY= new TherapeuticLinkTypeValues("deptpharmacy", "pharmacydelivery", "pharmacistreferral");
        public static readonly TherapeuticLinkTypeValues PERSPHARMACIST= new TherapeuticLinkTypeValues("perspharmacist", "pharmacydelivery", "pharmacistreferral");
        
        
        public static IEnumerable<TherapeuticLinkTypeValues> Values
        {
            get
            {
                yield return PERSNURSE;
                yield return PERSPHYSICIAN;
                yield return DEPTPHARMACY;
                yield return PERSPHARMACIST;
            }
        }
        
        private String hcpartyType;
        private String therlinkType;
        private String referral;
        
        private TherapeuticLinkTypeValues(String hcpType, String therlinkType, String referral) {
            this.hcpartyType=hcpType;
            this.therlinkType=therlinkType;
            this.setReferral(referral);
        }
        
        
        /**
         * @return the hcpartyType
         */
        public String getHcpartyType() {
            return hcpartyType;
        }
        
        
        /**
         * @return the therlinkType
         */
        public String getTherlinkType() {
            return therlinkType;
        }
        
        
        /**
         * @return
         */
        public String getReferralType() {
            return referral;
        }
        
        
        /**
         * @return the referral
         */
        public String getReferral() {
            return referral;
        }
        
        
        /**
         * @param referral the referral to set
         */
        public void setReferral(String referral) {
            this.referral = referral;
        }
        
        public static TherapeuticLinkTypeValues valueOf(String name)
        {
            foreach (TherapeuticLinkTypeValues element in Values)
            {
                if (element.getHcpartyType().ToUpper().Equals(name)){
                    return element;
                }
            }
            return null;
        }
        
    }
}
