﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using java.io;

using org.joda.time;

using be.ehealth.businessconnector.chapterIV.builders;
using be.ehealth.businessconnector.chapterIV.domain;
using be.ehealth.businessconnector.chapterIV.exception;
using be.ehealth.businessconnector.chapterIV.session;
using be.ehealth.businessconnector.chapterIV.testutil;
using be.ehealth.businessconnector.chapterIV.utils;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.protocol.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

namespace be.ehealth.businessconnector.chapterIV.integration
{
	/**
	 * Integration test for ChapterIV business connector
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class ChapterIVAdmissionIntegrationTest : AbstractChapterIV
	{
		/**
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testAdmissionValidRequestOA100() {
			if (isDoctor()) {
				performTestAdmission(".\\examples\\sample-chapter4-admission-request-with-ssin.xml", null, "57110204406");
			}
		}

		/**
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testAdmissionValidRequestOA500()  {
			if (isDoctor()) {
				performTestAdmission(".\\examples\\sample-chapter4-admission-request-with-ssin.xml", null, "76011402195");
			}
		}


		/**
		 * @param message
		 * @param agreementStartDate
		 * @throws TechnicalConnectorException
		 * @throws ConnectorException
		 * @throws SessionManagementException
		 * @throws UnsealConnectorException
		 */
		private void performTestAdmission(String location, org.joda.time.DateTime agreementStartDate, String patientInss) {

			InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream(location);
			FolderType message = parseFolderType(xmlResourceInputStream);
			message = TestUtils.updateFolderWithAuthorAndCurrentDate(message, patientInss);

			org.joda.time.DateTime startDate = agreementStartDate;
			if (startDate == null) {
				startDate = FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(message);
			}

			ChapterIVService service = ChapterIVSessionServiceFactory.getChapterIVService();
			try {
				ChapterIVReferences references = new ChapterIVReferences(true);
				AdmissionBuilder builder = BuilderFactory.getBuilderFactoryForSession().getAdmissionBuilder();
				ChapterIVBuilderResponse builderResponse = builder.build(message, true, references, startDate);

				AskChap4MedicalAdvisorAgreementResponse response = service.askChap4MedicalAdvisorAgreementResponse(builderResponse.getAskChap4MedicalAdvisorAgreementRequest());
				ChapterIVKmehrResponseWithTimeStampInfo retrievedKmehrResponse = getResponseBuilder().validateTimestampAndretrieveChapterIVKmehrResponseWithTimeStampInfo(response);
				Assert.IsNotNull(retrievedKmehrResponse);
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrresponse());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrresponse().getRequest());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrresponse().getRequest().getKmehrmessage());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampResponse());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrResponseBytes());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampBytes());
			} catch (SoaErrorException e) {
				processError(e, "AdmissionValid");
			} catch (ChapterIVBusinessConnectorException e) {
				processChapterIvBusinessException(service, e);
			}
		}
	}
}
