/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.session;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.kmehrcommons.helper.ErrorTypeManagement;
import be.fgov.ehealth.hubservices.core.v1.ConsentHCPartyType;
import be.fgov.ehealth.hubservices.core.v1.PutHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.PutPatientResponse;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCOUNTRY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCOUNTRYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSEX;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSEXvalues;
import be.fgov.ehealth.standards.kmehr.schema.v1.DateType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Nationality;
import be.fgov.ehealth.standards.kmehr.schema.v1.PersonType;
import be.fgov.ehealth.standards.kmehr.schema.v1.SexType;


/**
 * Other unique test are classed here.
 * 
 * @author EH054
 */
public class OtherIntegrationTest extends AbstractIntrahubIntegrationTest {

    /**
     * PutPatient Test
     */
    @Test
    public void putPatient() throws Exception {
        PersonType person = new PersonType();
        person.getFirstnames().add(PATIENT_FIRSTNAME);
        person.setFamilyname(PATIENT_LASTNAME);
        person.setRecorddatetime(new DateTime());
        person.setUsuallanguage("fr");

        DateType dateType = new DateType();
        dateType.setDate(new DateTime().withDayOfMonth(12).withMonthOfYear(12).withYear(1991));
        person.setBirthdate(dateType);

        Nationality nationality = new Nationality();
        CDCOUNTRY cdCountry = new CDCOUNTRY();
        cdCountry.setS(CDCOUNTRYschemes.CD_FED_COUNTRY);
        cdCountry.setSV(SV_CD);
        cdCountry.setValue("BE");
        nationality.setCd(cdCountry);
        person.setNationality(nationality);

        SexType sex = new SexType();
        CDSEX cdSex = new CDSEX();
        cdSex.setS("CD-SEX");
        cdSex.setSV(SV_CD);
        cdSex.setValue(CDSEXvalues.MALE);
        sex.setCd(cdSex);
        person.setSex(sex);

        person.getIds().add(createIdPatientInss());

        PutPatientResponse putPatient = hubServiceComplete.putPatient(person);

        List<ErrorType> errors = putPatient.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * PutHcPartyConsent Test
     */
    @Test
    public void putHcPartyConsent() throws Exception {
        ConsentHCPartyType consent = new ConsentHCPartyType();
        consent.setAuthor(createAuthor());
        consent.setHcparty(createHcPartyIdProfessional());
        consent.setRevokedate(new DateTime());
        consent.setSigndate(new DateTime());
        PutHCPartyConsentResponse putHCPartyConsent = hubServiceComplete.putHCPartyConsent(consent);

        List<ErrorType> errors = putHCPartyConsent.getAcknowledge().getErrors();
        // RevokeHcPartyConsent is an unsupported service
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty() || StringUtils.contains(errors.get(0).getCds().get(0).getValue(), "PERHCP.CONSENT.EXISTS"));

        hubServiceComplete.revokeHCPartyConsent(consent);
    }
}
