/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.builders;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;


/**
 * Test case for {@link ResponseBuilder}.
 * 
 * @author EHP
 * 
 */
public class ResponseBuilderTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseBuilderTest.class);

    static {
        LoggingUtils.bootstrap();
    }

    /**
     * Instance of the tested class
     */
    private ResponseBuilder builder = new ResponseBuilder();


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildIDKMEHRResponse(be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHR)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildIDKMEHRResponse() throws Exception {

        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/idkmehr.xml"));

        String actual = builder.buildIDKMEHRResponse(TestObjectBuilder.getIDKMEHR());
        XmlAsserter.assertSimilar(expected, actual);
    }


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildKmehrHeaderGetTransactionListResponse(be.fgov.ehealth.hubservices.core.v1.KmehrHeaderGetTransactionList)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildKmehrHeaderGetTransactionListResponse() throws Exception {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/kmehrheadergettransactionlist.xml"));

        String actual = builder.buildKmehrHeaderGetTransactionListResponse(TestObjectBuilder.getKmehrHeaderGetTransactionList());
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildKmehrmessageResponse(be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildKmehrmessageResponse() throws Exception {

        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/kmehrmessage.xml"));

        String actual = builder.buildKmehrmessageResponse(TestObjectBuilder.getKmehrmessageResponse());
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildHCPartyAdaptedTypeResponse(be.fgov.ehealth.hubservices.core.v1.HCPartyAdaptedType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildHCPartyAdaptedTypeResponse() throws Exception {

        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/hcpartyadaptedtype.xml"));

        String actual = builder.buildHCPartyAdaptedTypeResponse(TestObjectBuilder.getHCPartyAdaptedType());
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildPersonTypeResponse(be.fgov.ehealth.standards.kmehr.schema.v1.PersonType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildPersonTypeResponse() throws Exception {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/persontype.xml"));
        String actual = builder.buildPersonTypeResponse(TestObjectBuilder.getPersonTypeFull());
        LOGGER.debug("ResponseBuilderTest.testBuildPersonTypeResponse:expected : " + expected);
        LOGGER.debug("ResponseBuilderTest.testBuildPersonTypeResponse:actual   : " + actual);
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildConsentHCPartyTypeResponse(be.fgov.ehealth.hubservices.core.v1.ConsentHCPartyType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildConsentHCPartyTypeResponse() throws Exception {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/consenthcpartytype.xml"));
        String actual = builder.buildConsentHCPartyTypeResponse(TestObjectBuilder.getConsentHCPartyTypeResponse());
        XmlAsserter.assertSimilar(expected, actual);

    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildConsentTypeResponse(be.fgov.ehealth.hubservices.core.v1.ConsentType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildConsentTypeResponse() throws Exception {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/consenttype.xml"));

        String actual = builder.buildConsentTypeResponse(TestObjectBuilder.getConsentTypeResponse());
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildTherapeuticLinkTypeResponse(be.fgov.ehealth.hubservices.core.v1.TherapeuticLinkType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildTherapeuticLinkTypeResponse() throws Exception {

        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/therapeuticlinktype.xml"));
        String actual = builder.buildTherapeuticLinkTypeResponse(TestObjectBuilder.getTherapeuticLinkType());
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildAccessRightListTypeResponse(be.fgov.ehealth.hubservices.core.v1.AccessRightListType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildAccessRightListTypeResponse() throws Exception {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/accessrightlisttype.xml"));

        String actual = builder.buildAccessRightListTypeResponse(TestObjectBuilder.getAccessRightListType());
        XmlAsserter.assertSimilar(expected, actual);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.ResponseBuilder#buildTransactionAccessListTypeResponse(be.fgov.ehealth.hubservices.core.v1.TransactionAccessListType)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildTransactionAccessListTypeResponse() throws Exception {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/responses/transactionaccesslisttype.xml"));

        String actual = builder.buildTransactionAccessListTypeResponse(TestObjectBuilder.getTransactionAccessListType());
        XmlAsserter.assertSimilar(expected, actual);
    }


}
