/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.validators.impl;

import java.io.InputStream;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;


/**
 * tests if all xsd files can be loaded from the classpath.
 * 
 * @author EHP
 * 
 */
public class Chapter4ValidatorImplTest {

    private static final String[] XSD = {
        "/XSD/chapterIV_v1/IO-BE-ConsultUnaddressed.xsd", "/XSD/chapterIV_v1/IO-BE-AskUnaddressed.xsd", "/XSD/chapterIV_v1/IO-IM-ConsultAddressed.xsd", "/XSD/chapterIV_v1/IO-IM-AskAddressed.xsd", "/XSD/chapterIV_v1/chap4services-protocol-1_0.xsd", "/XSD/chapterIV_v1/medicalagreement-core-1_0.xsd", "/XSD/kmehr/kmehr_elements-1_5.xsd", "/XSD/chapterIV_v1/MCN_ask_encrypted_response.xsd", "/XSD/chapterIV_v1/MCN_consult_encrypted_response.xsd"
    };


    @Test
    public void testLoadXSDFromClassPath() throws Exception {
        for (String xsd : XSD) {
            InputStream inputStream = ConnectorIOUtils.getResourceAsStream(xsd);
            Assert.assertNotNull(inputStream);
        }
    }
}
