/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.integration;

import java.io.InputStream;
import java.util.List;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

import be.ehealth.business.kmehrcommons.helper.ErrorTypeManagement;
import be.ehealth.businessconnector.chapterIV.builders.BuilderFactory;
import be.ehealth.businessconnector.chapterIV.builders.ConsultationBuilder;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVBuilderResponse;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVKmehrResponseWithTimeStampInfo;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVReferences;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.businessconnector.chapterIV.session.ChapterIVService;
import be.ehealth.businessconnector.chapterIV.session.ChapterIVSessionServiceFactory;
import be.ehealth.businessconnector.chapterIV.testutil.TestUtils;
import be.ehealth.businessconnector.chapterIV.utils.FolderTypeUtils;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.UnsealConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementResponse;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrresponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;


/**
 * Integration test for ChapterIV business connector
 * 
 * @author EHP
 * 
 */
public class ChapterIVConsultationIntegrationTest extends AbstractChapterIVTestBase {


    /**
     * 
     * @throws Exception
     */
    @Test
    public void testConsultationValidRequestOA100() throws Exception {
        final InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream("/examples/sample-chapter4-consultation-request-with-ssin.xml");
        performTestConsultation(xmlResourceInputStream, "81032034303");
    }

    /**
     * 
     * @throws Exception
     */
    @Test
    @Ignore("this operation is not supported by backend at the moment")
    public void testConsultationValidRequestOA100NoNissNumberNotKnown() throws Exception {
        final InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream("/examples/sample-chapter4-consultation-request-without-ssin.xml");
        performTestConsultation(xmlResourceInputStream, null);
    }


    /**
     * 
     * @throws Exception
     */
    @Test
    public void testConsultationValidRequestOA500() throws Exception {
        final InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream("/examples/sample-chapter4-consultation-request-with-ssin.xml");
        performTestConsultation(xmlResourceInputStream, "76011402195");
    }

    /**
     * @param xmlResourceInputStream
     * @throws ConnectorException
     * @throws TechnicalConnectorException
     * @throws ChapterIVBusinessConnectorException
     * @throws SessionManagementException
     * @throws UnsealConnectorException
     */
    private void performTestConsultation(final InputStream xmlResourceInputStream, String patientInss) throws ConnectorException, TechnicalConnectorException, ChapterIVBusinessConnectorException, SessionManagementException, UnsealConnectorException {
        ChapterIVService service = ChapterIVSessionServiceFactory.getChapterIVService();
        FolderType folder = parseFolderType(xmlResourceInputStream);

        folder = TestUtils.updateFolderWithAuthorAndCurrentDate(folder, patientInss);

        try {
            DateTime agreementStartDate = FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(folder);
            ChapterIVReferences references = new ChapterIVReferences(true);
            ConsultationBuilder builder = BuilderFactory.getBuilderFactoryForSession().getConsultationBuilder();

            ChapterIVBuilderResponse builderResponse = builder.build(folder, true, references, agreementStartDate);
            ConsultChap4MedicalAdvisorAgreementResponse response = service.consultChap4MedicalAdvisorAgreement(builderResponse.getConsultChap4MedicalAdvisorAgreementRequest());
            ChapterIVKmehrResponseWithTimeStampInfo retrievedKmehrResponse = getResponseBuilder().validateTimestampAndretrieveChapterIVKmehrResponseWithTimeStampInfo(response);
            Assert.assertNotNull(retrievedKmehrResponse);
            Kmehrresponse kmehrresponse = retrievedKmehrResponse.getKmehrresponse();
            Assert.assertNotNull(kmehrresponse);
            Assert.assertNotNull(kmehrresponse.getRequest());
            Assert.assertNotNull(kmehrresponse.getRequest().getKmehrmessage());
            Assert.assertNotNull(retrievedKmehrResponse.getTimeStampResponse());
            Assert.assertNotNull(retrievedKmehrResponse.getKmehrResponseBytes());
            Assert.assertNotNull(retrievedKmehrResponse.getTimeStampBytes());
            List<ErrorType> errors = kmehrresponse.getAcknowledge().getErrors();
            Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
        } catch (SoaErrorException e) {
            processError(e, "ConsultationValid");
        } catch (ChapterIVBusinessConnectorException e) {
            processChapterIvBusinessException(service, e);
        }
    }


}
