/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.uddi;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Integration test to verify that the UDDI update works
 * 
 * @author Hannes De Clercq (ehd3)
 * 
 */
public class UddiUpdaterIntegrationTest {

    private static String location;

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init(true);
        location = System.getProperty("java.io.tmpdir");
        ConfigFactory.getConfigValidator().setProperty(UddiUpdater.PROP_UDDI_LOCAL_CACHE_DIR, location);
    }

    @Test
    public void test() throws Exception {
        UddiUpdater.launch();

        Properties props = new Properties();
        InputStream is = ConnectorIOUtils.getResourceAsStream(location + "uddi-local.properties");
        props.load(is);
        for (Object endpoint : props.values()) {
            assertURL(endpoint.toString());
        }
        is.close();

    }

    @After
    public void teardown() throws Exception {
        Assert.assertTrue(new File(location, "uddi-local.properties").delete());
    }

    private static void assertURL(String endpoint) {
        try {
            new URL(endpoint);
        } catch (MalformedURLException e) {
            Assert.fail();
        }
    }

    @XmlRootElement(name = "Request")
    @XmlType(name = "RequestType", propOrder = {"time"})
    private static class Request {

        @XmlElement(required = true)
        @XmlSchemaType(name = "time")
        protected XMLGregorianCalendar time;
    }

    public static void main(String[] args) {
        Request req = JAXB.unmarshal(new StringReader("<Request><time>11:29:11.0000008+02:00</time></Request>"), Request.class);
        JAXB.marshal(req, System.out);

    }
}
