/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.wsconsent.service;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.kmehrcommons.helper.ErrorTypeManagement;
import be.ehealth.businessconnector.wsconsent.exception.WsConsentBusinessConnectorException;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.hubservices.core.v2.ConsentType;
import be.fgov.ehealth.hubservices.core.v2.GetPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v2.PutPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v2.RevokePatientConsentResponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;


/**
 * integration test for the wsconsent connector. will test some scenarios.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class WsConsentServiceUserIntegrationTest extends AbstractWsConsentServiceIntegrationTest {


    @Test
    public void testPutPatientConsent() throws TechnicalConnectorException, WsConsentBusinessConnectorException, InstantiationException {
        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
        PutPatientConsentResponse response = putConsentForCurrentPatient(consentType);

        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getAcknowledge());
        Assert.assertNotNull(response.getResponse());

        List<ErrorType> errors = response.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());

        revokePatientconsent(consentType);
    }


    @Test
    public void testGetPatientConsent() throws TechnicalConnectorException, WsConsentBusinessConnectorException, InstantiationException {
        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
        putConsentForCurrentPatient(consentType);

        GetPatientConsentResponse response = retrievePatientConsentResponse();
        Assert.assertNotNull(response);

        Assert.assertTrue(response.getAcknowledge().isIscomplete());
        List<ErrorType> errors = response.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
        LOG.debug("Response: " + response);

        revokePatientconsent(consentType);
    }


    @Test
    public void testRevokePatientConsent() throws TechnicalConnectorException, WsConsentBusinessConnectorException, InstantiationException {
        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
        putConsentForCurrentPatient(consentType);

        RevokePatientConsentResponse response = revokePatientconsent(consentType);
        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getAcknowledge());
        Assert.assertNotNull(response.getResponse());

        Assert.assertTrue(response.getAcknowledge().isIscomplete());
        List<ErrorType> errors = response.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }


    @Test
    public void testPutPatientConsentWithSessionService() throws InstantiationException, ConnectorException {
        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
        PutPatientConsentResponse response = putConsentForCurrentPatientWithSessionService(consentType);
        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getAcknowledge());
        Assert.assertNotNull(response.getResponse());

        Assert.assertTrue(response.getAcknowledge().isIscomplete());
        List<ErrorType> errors = response.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());

        revokePatientconsentWithSessionService(consentType);
    }


    @Test
    public void testGetPatientConsentWithSessionService() throws InstantiationException, ConnectorException {
        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
        putConsentForCurrentPatientWithSessionService(consentType);

        GetPatientConsentResponse response = retrievePatientConsentResponseWithSessionService();
        Assert.assertNotNull(response);

        Assert.assertTrue(response.getAcknowledge().isIscomplete());
        List<ErrorType> errors = response.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
        LOG.debug("Response: " + response);

        revokePatientconsentWithSessionService(consentType);

    }


    @Test
    public void testRevokePatientConsentWithSessionService() throws InstantiationException, ConnectorException {
        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
        putConsentForCurrentPatientWithSessionService(consentType);

        RevokePatientConsentResponse response = revokePatientconsentWithSessionService(consentType);
        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getAcknowledge());
        Assert.assertNotNull(response.getResponse());

        Assert.assertTrue(response.getAcknowledge().isIscomplete());
        List<ErrorType> errors = response.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }


}
