/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.dmg.session;

import java.util.List;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.kmehrcommons.HcPartyUtil;
import be.ehealth.businessconnector.dmg.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.dmg.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.dmg.domain.DMGReferences;
import be.ehealth.businessconnector.dmg.util.DmgConstants;
import be.ehealth.businessconnector.dmg.util.DmgTestUtils;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleXmlSec;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.NotifyGlobalMedicalFileRequest;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.SendResponseType;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;

/**
 * Notify Integration Test.
 * 
 * @author EHP
 * 
 */
public class DmgNotificationIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(DmgNotificationIntegrationTest.class);


    @BeforeClass
    public static void init() throws Exception {
        LOG.debug("DmgConsultationIntegrationTest.loadSession:");
        new ConfigurationModuleXmlSec().init(null);
        SessionInitializer.init("/be.ehealth.businessconnector.dmg.test.properties");
        ConfigFactory.getConfigValidator().setProperty("be.ehealth.businessconnector.dmg.builders.impl.dumpMessages", "true");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void testOA300() throws Exception {
        Patient pI = DmgTestUtils.createPatient("Madeleine", "De Maret", 300, 59120346292L);
        baseNotificationTest(pI, "female", new DateTime().minusDays(1), "101076");
    }

    @Test
    public void testOA600() throws Exception {
        long inszNumber = 5041001640L;
        Patient pI = DmgTestUtils.createPatient("Ajse", "Osmani", 600, inszNumber);
        baseNotificationTest(pI, "female", new DateTime().minusDays(2), "101076");
    }


    private void baseNotificationTest(Patient pI, String sex, DateTime dmgEncounterDate, String nomenclature) throws Exception {
        // String firstname, String lastName, String mutuality, String regNrWithMut, String inss,

        Boolean istest = false;

        // DMGReferences ref = DmgTestUtils.createDmgReferenceForTest();
        DMGReferences ref = new DMGReferences(true);

        DateTime dateReference = new DateTime();
        Kmehrmessage request = DmgTestUtils.getFilledSendTransactionRequestFromXmlFile();
        AuthorType author = HcPartyUtil.createAuthor(DmgConstants.PROJECT_IDENTIFIER);
        List<HcpartyType> senderHcParties = author.getHcparties();
        HcpartyType dmgTarget = HcPartyUtil.createProfessionalParty(SessionUtil.getNiss(), SessionUtil.getNihii11(), "persphysician");
        dmgTarget.setFirstname(ConfigFactory.getConfigValidator().getProperty("user.firstname"));
        dmgTarget.setFamilyname(ConfigFactory.getConfigValidator().getProperty("user.lastname"));


        DmgTestUtils.replacePatientInFirstFolder(pI, sex, request);
        DmgTestUtils.replaceAuthorInFirstFolder(request, author);
        DmgTestUtils.replaceSenderInRequest(request, senderHcParties);
        DmgTestUtils.replaceDmgTargetInRequest(request, dmgTarget);
        DmgTestUtils.replaceEncounterDateInRequest(dmgEncounterDate, request);
        DmgTestUtils.replaceNomenclatureCodeInRequest(nomenclature, request);


        LOG.debug("Call of method from RequestObjectBuilder");
        RequestObjectBuilder reqBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();
        LOG.debug("created request for notification " + ConnectorXmlUtils.toString(request));
        NotifyGlobalMedicalFileRequest result = reqBuilder.buildSendNotifyRequest(istest, ref, pI, dateReference, request);


        LOG.debug("Call of session from DmgService");
        DmgService service = DmgSessionServiceFactory.getDmgService();
        SendResponseType resp = service.notifyGlobalMedicalFile(result);

        DmgTestUtils.validateSendResponseType(resp);

    }


}
