/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.civics.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.text.MessageFormat;

import org.junit.Test;

import be.fgov.ehealth.errors.soa.v1.SOAErrorType;


/**
 * Test class for {@link CivicsBusinessConnectorException}
 * 
 * @author EHP
 * 
 */
public class CivicsBusinessConnectorExceptionTest {

    /**
     * Tests a civics business connector exception with no text param
     */
    @Test
    public void testCivicsBusinessConnectorExceptionNoParam() {
        CivicsBusinessConnectorExceptionValues errorValue = CivicsBusinessConnectorExceptionValues.MALFORMED_URL;
        CivicsBusinessConnectorException error = new CivicsBusinessConnectorException(errorValue, new SOAErrorType());
        assertEquals(error.getErrorCode(), CivicsBusinessConnectorExceptionValues.MALFORMED_URL.getErrorCode());
        assertNotNull(error.getSOAError());
    }

    /**
     * Tests a civics business connector exception with text params
     */
    @Test
    public void testCivicsBusinessConnectorExceptionParams() {
        CivicsBusinessConnectorExceptionValues errorValue = CivicsBusinessConnectorExceptionValues.MALFORMED_URL;
        CivicsBusinessConnectorException error = new CivicsBusinessConnectorException(errorValue, new SOAErrorType(), "test");
        assertEquals(error.getErrorCode(), MessageFormat.format(CivicsBusinessConnectorExceptionValues.MALFORMED_URL.getErrorCode(), "test"));
        assertNotNull(error.getSOAError());
    }

    /**
     * Tests a civics business connector exception with a throwable
     */
    @Test
    public void testCivicsBusinessConnectorExceptionThrowable() {
        CivicsBusinessConnectorExceptionValues errorValue = CivicsBusinessConnectorExceptionValues.MALFORMED_URL;
        CivicsBusinessConnectorException error = new CivicsBusinessConnectorException(errorValue, new Throwable(), new SOAErrorType());
        assertEquals(error.getErrorCode(), CivicsBusinessConnectorExceptionValues.MALFORMED_URL.getErrorCode());
        assertNull(error.getSOAError());
    }
}
