/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.validators.impl;

import java.io.InputStream;

import org.junit.Test;

import be.ehealth.businessconnector.chapterIV.validators.Chapter4XmlValidator;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrresponse;


/**
 * Testclass to reproduce reported errors
 * 
 * @author EHP
 * 
 */
public class JiraIssueTest {

    /**
     * more information see https://jira.smals.be/browse/EHCONEXT-12
     * 
     * @throws Exception
     */
    @Test
    public void testParserErrorInResponse() throws Exception {
        final InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream("/examples/response/Response500.EHCONEXT-12.xml");
        MarshallerHelper<Kmehrresponse, Kmehrresponse> helper = new MarshallerHelper<Kmehrresponse, Kmehrresponse>(Kmehrresponse.class, Kmehrresponse.class);
        Kmehrresponse response = helper.toObject(xmlResourceInputStream);

        Chapter4XmlValidator validator = new Chapter4XmlValidatorImpl();
        validator.validate(response);

    }


}
