/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.testutil;

import java.io.InputStream;

import org.joda.time.DateTime;

import be.ehealth.businessconnector.chapterIV.builders.KmehrBuilder;
import be.ehealth.businessconnector.chapterIV.builders.KmehrBuilderFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementResponse;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.TransactionType;


/**
 * test utilities.
 * 
 * @author EHP
 * 
 */
public final class TestUtils {

    private static KmehrBuilder kmehrBuilder;


    /**
     * private constructor, non instatiation needed ,only static methods.
     */
    private TestUtils() {
        super();
    }


    public static ConsultChap4MedicalAdvisorAgreementResponse mapToConsultResponseObject(String fileLocation) throws Exception {
        InputStream ios = ConnectorIOUtils.getResourceAsStream(fileLocation);

        MarshallerHelper<ConsultChap4MedicalAdvisorAgreementResponse, ConsultChap4MedicalAdvisorAgreementResponse> helper = new MarshallerHelper<ConsultChap4MedicalAdvisorAgreementResponse, ConsultChap4MedicalAdvisorAgreementResponse>(ConsultChap4MedicalAdvisorAgreementResponse.class, ConsultChap4MedicalAdvisorAgreementResponse.class);
        return helper.toObject(ios);

    }

    public static String getFileContents(String fileLocation) throws TechnicalConnectorException {
        return ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(fileLocation));
    }

    public static KmehrBuilder getKmehrBuilder() throws TechnicalConnectorException {
        if (kmehrBuilder == null) {
            kmehrBuilder = KmehrBuilderFactory.getKmehrBuilder();
        }
        return kmehrBuilder;
    }

    public static FolderType updateFolderWithAuthorAndCurrentDate(FolderType folder, String patientInss) throws TechnicalConnectorException {
        if (folder != null) {
            for (TransactionType transaction : folder.getTransactions()) {
                transaction.setAuthor(getKmehrBuilder().generateAuthor());
                transaction.setDate(new DateTime());
                transaction.setTime(new DateTime());
            }

            for (IDPATIENT idPatient : folder.getPatient().getIds()) {
                idPatient.setValue(patientInss);
            }
        }
        return folder;
    }


    /**
     * @param message
     * @return
     * @throws TechnicalConnectorException
     */
    public static FolderType updateFolderWithAuthorAndCurrentDate(FolderType folder) throws TechnicalConnectorException {
        if (folder != null) {
            for (TransactionType transaction : folder.getTransactions()) {
                transaction.setAuthor(getKmehrBuilder().generateAuthor());
                transaction.setDate(new DateTime());
                transaction.setTime(new DateTime());
            }
        }
        return folder;
    }

}
