/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Properties;

import org.junit.Test;

import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.business.mycarenetcommons.domain.Nihii;
import be.ehealth.business.mycarenetcommons.domain.Party;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * Abstract class used as base for the testing
 * 
 * @author EHP
 */
public class AbstractCommonBuilderImplTest {

    /**
     * 
     */
    protected static final String PROP_EXAMPLE_NISS = "test.mycarenetcommons.example.niss";

    /**
     * 
     */
    protected static final String PROP_EXAMPLE_NAME = "test.mycarenetcommons.example.name";

    protected static final String MYCARENET_PROJECTNAME_SENDER_PERSON_SSIN = "mycarenet.default.sender.physicalperson.ssin";

    protected static final String MYCARENET_PROJECTNAME_SENDER_PERSON_NAME = "mycarenet.default.sender.physicalperson.name";

    protected static final String MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_NAME = "mycarenet.default.sender.organization.name";

    protected static final String MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_NIHII_VALUE = "mycarenet.default.sender.organization.nihii.value";

    protected static final String MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_NIHII_QUALITY = "mycarenet.default.sender.organization.nihii.quality";

    protected static final String MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_CBE = "mycarenet.default.sender.organization.cbe";

    private ConfigValidator configValidator = ConfigFactory.getConfigValidator();

    protected AbstractCommonBuilderImpl builder = new AbstractCommonBuilderImpl() {

        @Override
        protected CareProvider createCareProviderForOrigin() throws NumberFormatException, TechnicalConnectorException {
            return null;
        }
    };


    @Test
    public void createSenderObjectWithParametersWithValidPhysicalPerson() throws Exception {
        /**
         * config for physical person mycarenet.projectName.sender.person.ssin= <br/>
         * mycarenet.projectName.sender.person.name=
         */

        Properties properties = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.mycarenetcommons.test.properties");
        String name = properties.getProperty(PROP_EXAMPLE_NAME);
        String ssin = properties.getProperty(PROP_EXAMPLE_NISS);
        setSenderOrganizationProperties(null, null, null);
        setSenderPhysicalPersonProperties(name, ssin);
        testCreateSenderForOriginPhysicalPerson(name, ssin);
    }


    /**
     * @param name
     * @param ssin
     * @throws TechnicalConnectorException
     */
    protected void testCreateSenderForOriginPhysicalPerson(String name, String ssin) throws TechnicalConnectorException {
        Party senderForOrigin = builder.createSenderForOrigin();
        assertNotNull("Sender object should not be null", senderForOrigin);
        assertNotNull("PhysicalPerson should not be null", senderForOrigin.getPhysicalPerson());
        assertNull("Organization should be null", senderForOrigin.getOrganization());
        assertNotNull(senderForOrigin.getPhysicalPerson().getSsin());
        assertNull(senderForOrigin.getPhysicalPerson().getNihii());
        assertEquals(ssin, senderForOrigin.getPhysicalPerson().getSsin());
        assertEquals(name, senderForOrigin.getPhysicalPerson().getName());
    }


    /**
     * @param name
     * @param ssin
     */
    protected void setSenderPhysicalPersonProperties(String name, String ssin) {
        configValidator.setProperty(MYCARENET_PROJECTNAME_SENDER_PERSON_NAME, name);
        configValidator.setProperty(MYCARENET_PROJECTNAME_SENDER_PERSON_SSIN, ssin);
    }


    protected void setSenderOrganizationProperties(String name, Nihii nihii, String cbe) {
        configValidator.setProperty(MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_NAME, name);
        String nihiiQuality = nihii == null ? null : nihii.getQuality();
        String nihiiValue = nihii == null ? null : nihii.getValue();
        configValidator.setProperty(MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_NIHII_QUALITY, nihiiQuality);
        configValidator.setProperty(MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_NIHII_VALUE, nihiiValue);
        configValidator.setProperty(MYCARENET_PROJECTNAME_SENDER_ORGANIZATION_CBE, cbe);
    }

    /**
     * @param name
     * @param ssin
     * @throws TechnicalConnectorException
     */
    protected void testCreateSenderForOriginOrganization(String name, Nihii nihii, String cbe) throws TechnicalConnectorException {
        String nihiiQuality = nihii == null ? null : nihii.getQuality();
        String nihiiValue = nihii == null ? null : nihii.getValue();

        Party senderForOrigin = builder.createSenderForOrigin();
        assertNotNull(senderForOrigin);
        assertNotNull(senderForOrigin.getOrganization());
        assertNull("PhysicalPerson should be null", senderForOrigin.getPhysicalPerson());
        if (nihii != null) {
            assertEquals(nihiiValue, senderForOrigin.getOrganization().getNihii().getValue());
            assertEquals(nihiiQuality, senderForOrigin.getOrganization().getNihii().getQuality());
        }
        assertEquals(cbe, senderForOrigin.getOrganization().getCbe());
        assertEquals(name, senderForOrigin.getOrganization().getName());
    }
}
