/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.registration.service;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String PROP_ENDPOINT_REGISTRATION_V1 = "endpoint.mcn.registration";
    private static final String PROP_VALIDATION_INCOMING_CONS_REGISTRATION = "validation.incoming.message.mcn.registration";
    private static final String REGISTRATION_PROT = "/ehealth-mycarenetregistration/XSD/mycarenet-registration-protocol-1_0.xsd";
    private static Configuration config;
    static final String[] REGISTRATION_XSD;

    private ServiceFactory() {
    }

    public static GenericRequest getRegistrationService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_REGISTRATION_V1));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_CONS_REGISTRATION))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, REGISTRATION_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, REGISTRATION_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    static {
        expectedProps.add(PROP_ENDPOINT_REGISTRATION_V1);
        config = ConfigFactory.getConfigValidator(expectedProps);
        REGISTRATION_XSD = new String[]{REGISTRATION_PROT};
    }
}

