/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink.domain;

import be.ehealth.businessconnector.therlink.domain.Author;
import be.ehealth.businessconnector.therlink.domain.Proof;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.DateTime;

public class OperationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String operation;
    private DateTime recordDate;
    private Author author;
    private List<Proof> proofs;

    @Deprecated
    public OperationContext(String operation, Calendar recordDate, Author author, List<Proof> proofs) {
    }

    public OperationContext(DateTime recordDate, String operation, Author author, List<Proof> proofs) {
        this.operation = operation;
        this.recordDate = recordDate;
        this.author = author;
        this.proofs = proofs;
    }

    public OperationContext() {
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public DateTime getRecordDateTime() {
        return this.recordDate;
    }

    public void setRecordDateTime(DateTime recordDate) {
        this.recordDate = recordDate;
    }

    @Deprecated
    public Calendar getRecordDate() {
        return this.recordDate.toGregorianCalendar();
    }

    @Deprecated
    public void setRecordDate(Calendar recordDate) {
        this.recordDate = new DateTime((Object)recordDate);
    }

    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public List<Proof> getProofs() {
        return this.proofs;
    }

    public void setProofs(List<Proof> proofs) {
        this.proofs = proofs;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.operation);
        builder.append((Object)this.author);
        builder.append(this.proofs);
        builder.append((Object)this.recordDate);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationContext)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        OperationContext other = (OperationContext)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.operation, (Object)other.operation);
        builder.append((Object)this.author, (Object)other.author);
        builder.append(this.proofs, other.proofs);
        builder.append((Object)this.recordDate, (Object)other.recordDate);
        return builder.isEquals();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append((Object)this.operation);
        builder.append((Object)this.author);
        builder.append(this.proofs);
        builder.append((Object)this.recordDate);
        return builder.toString();
    }

    public static class Builder {
        private OperationContext operationContext = new OperationContext();

        public Builder withOperation(String operation) {
            this.operationContext.setOperation(operation);
            return this;
        }

        @Deprecated
        public Builder withRecordDate(Calendar recordDate) {
            this.operationContext.setRecordDateTime(new DateTime((Object)recordDate));
            return this;
        }

        public Builder withRecordDateTime(DateTime recordDate) {
            this.operationContext.setRecordDateTime(recordDate);
            return this;
        }

        public Builder withAuthor(Author author) {
            this.operationContext.setAuthor(author);
            return this;
        }

        public Builder addProof(Proof proof) {
            this.operationContext.getProofs().add(proof);
            return this;
        }

        public OperationContext build() {
            return this.operationContext;
        }
    }
}

