/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.civics.session.impl;

import be.ehealth.businessconnector.civics.exception.CivicsBusinessConnectorException;
import be.ehealth.businessconnector.civics.exception.CivicsBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.civics.service.SamCivicsService;
import be.ehealth.businessconnector.civics.service.ServiceFactory;
import be.ehealth.businessconnector.civics.session.CivicsService;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionManager;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.fgov.ehealth.errors.soa.v1.SOAErrorType;
import be.fgov.ehealth.samcivics.type.v1.FindCNKRequest;
import be.fgov.ehealth.samcivics.type.v1.FindCNKResponse;
import be.fgov.ehealth.samcivics.type.v1.FindParagraphTextResponse;
import be.fgov.ehealth.samcivics.type.v1.FindReimbursementConditionsRequest;
import be.fgov.ehealth.samcivics.type.v1.FindReimbursementConditionsResponse;
import be.fgov.ehealth.samcivics.type.v1.GetAddedDocumentsResponse;
import be.fgov.ehealth.samcivics.type.v1.GetParagraphExclusionsResponse;
import be.fgov.ehealth.samcivics.type.v1.GetParagraphIncludedSpecialitiesResponse;
import be.fgov.ehealth.samcivics.type.v1.GetProfessionalAuthorisationsRequest;
import be.fgov.ehealth.samcivics.type.v1.GetProfessionalAuthorisationsResponse;
import be.fgov.ehealth.samcivics.type.v1.ParagraphAndVersesRequestType;
import be.fgov.ehealth.samcivics.type.v1.ParagraphRequestType;

public class CivicsServiceImpl
implements CivicsService {
    private SamCivicsService service;

    public CivicsServiceImpl(SessionValidator sessionValidator) throws TechnicalConnectorException {
        this.service = ServiceFactory.getSamCivicsService(sessionValidator);
    }

    @Override
    public FindParagraphTextResponse findParagraphText(ParagraphAndVersesRequestType request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        FindParagraphTextResponse response = this.service.findParagraphText(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }

    @Override
    public GetParagraphIncludedSpecialitiesResponse getParagraphIncludedSpecialties(ParagraphRequestType request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        GetParagraphIncludedSpecialitiesResponse response = this.service.getParagraphIncludedSpecialties(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }

    @Override
    public GetParagraphExclusionsResponse getParagraphExclusions(ParagraphRequestType request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        GetParagraphExclusionsResponse response = this.service.getParagraphExclusions(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }

    @Override
    public GetProfessionalAuthorisationsResponse getProfessionalAuthorizations(GetProfessionalAuthorisationsRequest request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        GetProfessionalAuthorisationsResponse response = this.service.getProfessionalAuthorizations(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }

    @Override
    public GetAddedDocumentsResponse getAddedDocuments(ParagraphAndVersesRequestType request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        GetAddedDocumentsResponse response = this.service.getAddedDocuments(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }

    @Override
    public FindReimbursementConditionsResponse findReimbursementConditions(FindReimbursementConditionsRequest request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        FindReimbursementConditionsResponse response = this.service.findReimbursementConditions(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }

    @Override
    public FindCNKResponse findCNK(FindCNKRequest request) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        SessionManager sessionInstance = Session.getInstance();
        if (sessionInstance.getSession() == null || sessionInstance.getSession().getSAMLToken() == null) {
            throw new CivicsBusinessConnectorException(CivicsBusinessConnectorExceptionValues.ERROR_NOSESSIONFOUND, (SOAErrorType)null, new Object[0]);
        }
        SAMLToken token = sessionInstance.getSession().getSAMLToken();
        FindCNKResponse response = this.service.findCNK(token.getCertificate(), token.getPrivateKey(), request);
        return response;
    }
}

