/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.dmg.service;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.LoggingHandler;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFactory.class);
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String PROP_ENDPOINT_DMG_CONSULTATION_V1 = "endpoint.dmg.consultation.v1";
    private static final String PROP_ENDPOINT_DMG_NOTIFICATION_V1 = "endpoint.dmg.notification.v1";
    private static final String PROP_VALIDATION_INCOMING_CONS_DMG = "validation.incoming.message.dmg.consultation.v1";
    private static final String PROP_VALIDATION_INCOMING_NOT_DMG = "validation.incoming.message.dmg.notification.v1";
    private static final String DMG_PROT = "/XSD/gmf_v1/gmf_services_protocol-1_0.xsd";
    private static final String DMG_CORE = "/XSD/gmf_v1/gmf_services_core-1_0.xsd";
    private static final String EXT_XMLMIME = "/XSD/external/xmlmime.xsd";
    private static final String COM_SCHEMA_PROT = "/XSD/common/ehealth-commons-schema-protocol-1_6.xsd";
    private static final String COM_SCHEMA_CORE = "/XSD/common/ehealth-commons-schema-core-1_6.xsd";
    private static final String COM_SCHEMA_SOA = "/XSD/common/ehealth-errors-schema-soa-1_0.xsd";
    private static final String COM_ERRORS_SCHEMA_CORE = "/XSD/common/ehealth-errors-schema-core-1_0.xsd";
    private static final String XML = "/XSD/external/xml.xsd";
    private static Configuration config;
    static final String[] DMG_XSD;

    private ServiceFactory() {
    }

    public static GenericRequest getConsultationService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_DMG_CONSULTATION_V1));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_CONS_DMG))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, DMG_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, DMG_XSD));
        }
        chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new LoggingHandler());
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    public static GenericRequest getNotificationService(SAMLToken token) throws TechnicalConnectorException {
        LOG.debug("getNotificationService : creating service");
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_DMG_NOTIFICATION_V1));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_NOT_DMG))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, DMG_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, DMG_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    static {
        DMG_XSD = new String[]{XML, EXT_XMLMIME, COM_ERRORS_SCHEMA_CORE, COM_SCHEMA_SOA, COM_SCHEMA_CORE, DMG_CORE, COM_SCHEMA_PROT, DMG_PROT};
        expectedProps.add(PROP_ENDPOINT_DMG_CONSULTATION_V1);
        expectedProps.add(PROP_ENDPOINT_DMG_NOTIFICATION_V1);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

