/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.tarification.service;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String PROP_ENDPOINT_TARIFICATION_V1 = "endpoint.mcn.tarification";
    private static final String PROP_VALIDATION_INCOMING_CONS_TARIFICATION = "validation.incoming.message.mcn.tarification";
    private static final String TARIFICATION_PROT = "/ehealth-mycarenet-tarification/XSD/mycarenet-tarification-protocol-1_0.xsd";
    private static Configuration config;
    public static final String TARIFICATION_XSD = "/ehealth-mycarenet-tarification/XSD/mycarenet-tarification-protocol-1_0.xsd";

    private ServiceFactory() {
    }

    public static GenericRequest getTarificationService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_TARIFICATION_V1));
        genReq.setSoapAction("urn:be:fgov:ehealth:mycarenet:tarification:protocol:v1:TarificationConsult");
        genReq.setCredential((Credential)token, TokenType.SAML);
        genReq.setDefaultHandlerChain();
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_CONS_TARIFICATION))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, new String[]{"/ehealth-mycarenet-tarification/XSD/mycarenet-tarification-protocol-1_0.xsd"}));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, new String[]{"/ehealth-mycarenet-tarification/XSD/mycarenet-tarification-protocol-1_0.xsd"}));
        }
        genReq.setHandlerChain(chain);
        return genReq;
    }

    static {
        expectedProps.add(PROP_ENDPOINT_TARIFICATION_V1);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

