/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.chapterIV.validators.impl;

import be.cin.io.sealed.medicaladvisoragreement.consult.v1.Request;
import be.cin.io.unsealed.medicaladvisoragreement.ask.v1.Response;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.chapterIV.validators.Chapter4XmlValidator;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import be.fgov.ehealth.chap4.protocol.v1.AskChap4MedicalAdvisorAgreementRequest;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementRequest;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrrequest;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrresponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import java.util.HashMap;
import java.util.Map;

public class Chapter4XmlValidatorImpl
implements Chapter4XmlValidator,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final long serialVersionUID = -1497994839194474681L;
    private static final Map<Class, String> XSD_FILE_LOCATION_FOR_CLASS_MAP = new HashMap<Class, String>();

    @Override
    public void validate(Object xmlObject) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        if (xmlObject == null) {
            throw new ChapterIVBusinessConnectorException(ChapterIVBusinessConnectorExceptionValues.ERROR_XML_CHAPTER4VALIDATOR, "xml object had null value");
        }
        ValidatorHelper.validate((Object)xmlObject, xmlObject.getClass(), (String)this.getXsdFileLocationForXmlObject(xmlObject));
    }

    private String getXsdFileLocationForXmlObject(Object xmlObject) throws ChapterIVBusinessConnectorException {
        if (xmlObject != null && XSD_FILE_LOCATION_FOR_CLASS_MAP.containsKey(xmlObject.getClass())) {
            return XSD_FILE_LOCATION_FOR_CLASS_MAP.get(xmlObject.getClass());
        }
        throw new ChapterIVBusinessConnectorException(ChapterIVBusinessConnectorExceptionValues.ERROR_XML_UNDEFINED_XSD_FOR_XML_CLASS_VALIDATOR, "no xsd source defined for xmlObject " + xmlObject);
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{be.cin.io.unsealed.medicaladvisoragreement.consult.v1.Request.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{be.cin.io.unsealed.medicaladvisoragreement.ask.v1.Request.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Request.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{be.cin.io.sealed.medicaladvisoragreement.ask.v1.Request.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ConsultChap4MedicalAdvisorAgreementRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{AskChap4MedicalAdvisorAgreementRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrrequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrmessage.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Response.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{be.cin.io.unsealed.medicaladvisoragreement.consult.v1.Response.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrresponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FolderType.class});
    }

    static {
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(be.cin.io.unsealed.medicaladvisoragreement.consult.v1.Request.class, "/XSD/chapterIV_v1/IO-BE-ConsultUnaddressed.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(be.cin.io.unsealed.medicaladvisoragreement.ask.v1.Request.class, "/XSD/chapterIV_v1/IO-BE-AskUnaddressed.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(Request.class, "/XSD/chapterIV_v1/IO-IM-ConsultAddressed.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(be.cin.io.sealed.medicaladvisoragreement.ask.v1.Request.class, "/XSD/chapterIV_v1/IO-IM-AskAddressed.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(ConsultChap4MedicalAdvisorAgreementRequest.class, "/XSD/chapterIV_v1/chap4services-protocol-1_0.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(AskChap4MedicalAdvisorAgreementRequest.class, "/XSD/chapterIV_v1/chap4services-protocol-1_0.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(Kmehrrequest.class, "/XSD/chapterIV_v1/medicalagreement-core-1_0.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(Kmehrmessage.class, "/XSD/kmehr/kmehr_elements-1_5.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(Response.class, "/XSD/chapterIV_v1/MCN_ask_encrypted_response.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(be.cin.io.unsealed.medicaladvisoragreement.consult.v1.Response.class, "/XSD/chapterIV_v1/MCN_consult_encrypted_response.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(Kmehrresponse.class, "/XSD/chapterIV_v1/medicalagreement-core-1_0.xsd");
        XSD_FILE_LOCATION_FOR_CLASS_MAP.put(FolderType.class, "/XSD/kmehr/kmehr_elements-1_5.xsd");
    }
}

