/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.chapterIV.service;

import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String PROP_ENDPOINT_CHIV_CONSULTATION_V1 = "endpoint.ch4.consultation.v1";
    private static final String PROP_ENDPOINT_CHIV_ADMISSION_V1 = "endpoint.ch4.admission.v1";
    private static final String PROP_VALIDATION_INCOMING_CONS_CHIV = "validation.incoming.chapterIV.consultation.message";
    private static final String PROP_VALIDATION_INCOMING_ADM_CHIV = "validation.incoming.chapterIV.admission.message";
    private static final String CH4_PROT = "/XSD/chapterIV_v1/chap4services-protocol-1_0.xsd";
    private static final String COM_SCHEMA_PROT = "/XSD/common/ehealth-commons-schema-protocol-1_6.xsd";
    private static final String CH4_CORE = "/XSD/chapterIV_v1/chap4services-core-1_0.xsd";
    private static final String COM_SCHEMA_CORE = "/XSD/common/ehealth-commons-schema-core-1_6.xsd";
    private static final String COM_SCHEMA_SOA = "/XSD/common/ehealth-errors-schema-soa-1_0.xsd";
    private static final String COM_ERRORS_SCHEMA_CORE = "/XSD/common/ehealth-errors-schema-core-1_0.xsd";
    private static final String XML = "/XSD/external/xml.xsd";
    private static Configuration config;
    protected static final String[] CH4_XSD;

    private ServiceFactory() {
    }

    public static GenericRequest getConsultationService(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, ChapterIVBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_CHIV_CONSULTATION_V1));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_CONS_CHIV))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, CH4_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, CH4_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    public static GenericRequest getAdmissionService(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, ChapterIVBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_CHIV_ADMISSION_V1));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_ADM_CHIV))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, CH4_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, CH4_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    static {
        CH4_XSD = new String[]{XML, COM_ERRORS_SCHEMA_CORE, COM_SCHEMA_SOA, COM_SCHEMA_CORE, CH4_CORE, COM_SCHEMA_PROT, CH4_PROT};
        expectedProps.add(PROP_ENDPOINT_CHIV_CONSULTATION_V1);
        expectedProps.add(PROP_ENDPOINT_CHIV_ADMISSION_V1);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

