/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.wsconsent.service.impl;

import be.ehealth.businessconnector.wsconsent.exception.WsConsentBusinessConnectorException;
import be.ehealth.businessconnector.wsconsent.service.WsConsentService;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import be.fgov.ehealth.hubservices.core.v2.GetPatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v2.GetPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v2.PutPatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v2.PutPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v2.RevokePatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v2.RevokePatientConsentResponse;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPHandler;

public class WsConsentServiceImpl
implements WsConsentService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String SOAPACTION_PUT_CONSENT = "urn:be:fgov:ehealth:consent:protocol:v1:PutPatientConsent";
    private static final String SOAPACTION_GET_CONSENT = "urn:be:fgov:ehealth:consent:protocol:v1:GetPatientConsent";
    private static final String SOAPACTION_REVOKE_CONSENT = "urn:be:fgov:ehealth:consent:protocol:v1:RevokePatientConsent";
    private static final String PROP_ENDPOINT_WSCONSENT_V1 = "endpoint.wsconsent";
    private static final String PROP_VALIDATION_INCOMING_WSCONSENT = "validation.incoming.wsconsent.message";
    private static final String WSCONSENT_PROT = "/ehealth-hubservices/XSD/hubservices_protocol-2_1.xsd";
    private static Configuration config;
    protected static final String[] WSCONSENT_XSD;

    protected GenericRequest getPort(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest req = new GenericRequest();
        req.setCredential((Credential)token, TokenType.SAML);
        req.setEndpoint(config.getProperty(PROP_ENDPOINT_WSCONSENT_V1));
        HandlerChain handlers = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_WSCONSENT))) {
            handlers.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, WSCONSENT_XSD));
        } else {
            handlers.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, WSCONSENT_XSD));
        }
        req.setHandlerChain(handlers);
        req.setDefaultHandlerChain();
        return req;
    }

    @Override
    public PutPatientConsentResponse putPatientConsent(SAMLToken token, PutPatientConsentRequest request) throws WsConsentBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        GenericRequest req = this.getPort(token);
        req.setPayload((Object)request);
        req.setSoapAction(SOAPACTION_PUT_CONSENT);
        GenericResponse resp = ServiceFactory.getGenericWsSender().send(req);
        try {
            return (PutPatientConsentResponse)resp.asObject(PutPatientConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
    }

    @Override
    public GetPatientConsentResponse getPatientConsent(SAMLToken token, GetPatientConsentRequest request) throws WsConsentBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        GenericRequest req = this.getPort(token);
        req.setPayload((Object)request);
        req.setSoapAction(SOAPACTION_GET_CONSENT);
        GenericResponse resp = ServiceFactory.getGenericWsSender().send(req);
        try {
            return (GetPatientConsentResponse)resp.asObject(GetPatientConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
    }

    @Override
    public RevokePatientConsentResponse revokePatientConsent(SAMLToken token, RevokePatientConsentRequest request) throws WsConsentBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        GenericRequest req = this.getPort(token);
        req.setPayload((Object)request);
        req.setSoapAction(SOAPACTION_REVOKE_CONSENT);
        GenericResponse resp = ServiceFactory.getGenericWsSender().send(req);
        try {
            return (RevokePatientConsentResponse)resp.asObject(RevokePatientConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokePatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokePatientConsentResponse.class});
    }

    static {
        WSCONSENT_XSD = new String[]{WSCONSENT_PROT};
        expectedProps.add(PROP_ENDPOINT_WSCONSENT_V1);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

