/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.vsbnetinsurability.session.impl;

import be.ehealth.businessconnector.vsbnetinsurability.service.VSBNetInsurabilityService;
import be.ehealth.businessconnector.vsbnetinsurability.service.impl.VSBNetnsurabilityServiceImpl;
import be.ehealth.businessconnector.vsbnetinsurability.session.VSBNetInsurabilitySessionService;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.EhealthReplyValidator;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityRequest;
import be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSBNetnsurabilitySessionServiceImpl
implements VSBNetInsurabilitySessionService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private VSBNetInsurabilityService service;
    private SessionValidator sessionValidator;
    private static final Logger LOG = LoggerFactory.getLogger(VSBNetnsurabilitySessionServiceImpl.class);

    public VSBNetnsurabilitySessionServiceImpl(SessionValidator sessionValidator, EhealthReplyValidator replyValidator) throws TechnicalConnectorException {
        this.service = new VSBNetnsurabilityServiceImpl(sessionValidator);
        this.sessionValidator = sessionValidator;
        if (!Session.getInstance().hasValidSession()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION, new Object[0]);
        }
    }

    public VSBNetnsurabilitySessionServiceImpl() {
        LOG.debug("creating VSBNetInsurabilitySessionServiceImpl for bootstrap purposes");
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityResponse.class});
    }

    @Override
    public GetInsurabilityResponse getInsurability(GetInsurabilityRequest request) throws TechnicalConnectorException {
        this.sessionValidator.validateSession();
        return this.service.getInsurability(Session.getInstance().getSession().getSAMLToken(), request);
    }
}

