/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.vsbnetinsurability.service;

import be.ehealth.business.common.util.HandlerChainUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.TokenType;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_VSBNETINSURABILITY_MYCARENET_V1 = "endpoint.mcn.vsbnetinsurability";
    private static final String PROP_VALIDATION_INCOMING_CONS_VSBNETINSURABILITY_MYCARENET = "validation.incoming.message.mcn.vsbnetinsurability";
    public static final String VSBNETINSURABILITY_PROT = "/ehealth-vsb-insurability/XSD/vsb-insurability-protocol-1_0.xsd";
    private static Configuration config = ConfigFactory.getConfigValidator();

    private ServiceFactory() {
    }

    public static GenericRequest getVSBInsurabilityService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_VSBNETINSURABILITY_MYCARENET_V1, "$uddi{uddi:ehealth-fgov-be:business:vsbnetinsurability:v1}"));
        genReq.setSoapAction("urn:be:fgov:ehealth:vsb:insurability:protocol:v1:GetInsurability");
        genReq.setCredential((Credential)token, TokenType.SAML);
        genReq.addDefaulHandlerChain();
        genReq.addHandlerChain(HandlerChainUtil.buildChainWithValidator((String)PROP_VALIDATION_INCOMING_CONS_VSBNETINSURABILITY_MYCARENET, (String[])new String[]{VSBNETINSURABILITY_PROT}));
        return genReq;
    }
}

