/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.recipe.validators.impl;

import be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException;
import be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.recipe.validators.PrescriberServiceValidator;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PrescriberServiceValidatorImpl
implements PrescriberServiceValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PrescriberServiceValidatorImpl.class);
    private String beginningTab = "\t## ";
    private String patientIdNotSet = "PatientID is not set";

    @Override
    public boolean validatePrescriptionId(String prescriptionId) throws RecipeBusinessConnectorException {
        if (prescriptionId == null || "".equals(prescriptionId)) {
            String errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage();
            LOG.debug(this.beginningTab + MessageFormat.format(errorValue, "PrescriptionId is not set"));
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL, "PrescriptionId is not set");
        }
        return true;
    }

    @Override
    public boolean validatePatientId(Long patientId) throws RecipeBusinessConnectorException {
        if (patientId == null || patientId == 0L) {
            String errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage();
            LOG.debug(this.beginningTab + MessageFormat.format(errorValue, this.patientIdNotSet));
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL, this.patientIdNotSet);
        }
        return true;
    }

    @Override
    public boolean validateExecutorId(Long executorId) throws RecipeBusinessConnectorException {
        if (executorId == null || executorId == 0L) {
            String errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage();
            LOG.debug(this.beginningTab + MessageFormat.format(errorValue, this.patientIdNotSet));
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL, this.patientIdNotSet);
        }
        return true;
    }

    @Override
    public boolean validatePrescriptionType(String prescriptionType) throws RecipeBusinessConnectorException {
        boolean valid = false;
        if (prescriptionType == null || "".equals(prescriptionType)) {
            String errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage();
            LOG.debug(this.beginningTab + MessageFormat.format(errorValue, this.patientIdNotSet));
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL, "Prescription Type is not set");
        }
        if ("PP".equalsIgnoreCase(prescriptionType)) {
            LOG.info("Prescription Type PP found");
            valid = true;
        } else if ("P0".equalsIgnoreCase(prescriptionType)) {
            LOG.info("Prescription Type P0 found");
            valid = true;
        } else if ("P1".equalsIgnoreCase(prescriptionType)) {
            LOG.info("Prescription Type P1 found");
            valid = true;
        } else if ("P2".equalsIgnoreCase(prescriptionType)) {
            LOG.info("Prescription Type P2 found");
            valid = true;
        } else {
            String errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage();
            String param = "Prescription Type is not valid: " + prescriptionType;
            LOG.debug(this.beginningTab + MessageFormat.format(errorValue, param));
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL, param);
        }
        return valid;
    }
}

