/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.mycarenet.memberdata.builders.impl;

import be.cin.encrypted.BusinessContent;
import be.cin.encrypted.EncryptedKnownContent;
import be.ehealth.business.mycarenetcommons.mapper.v3.BlobMapper;
import be.ehealth.business.mycarenetcommons.mapper.v3.CommonInputMapper;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.CommonBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.mycarenet.memberdata.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.mycarenet.memberdata.exception.MemberDataBusinessConnectorException;
import be.ehealth.businessconnector.mycarenet.memberdata.exception.MemberDataBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.mycarenet.memberdata.security.MemberDataEncryptionUtil;
import be.ehealth.businessconnector.mycarenet.memberdata.validators.impl.MemberDataXmlValidatorImpl;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.messageservices.core.v1.SendTransactionRequest;
import be.fgov.ehealth.mycarenet.commons.core.v3.CommonInputType;
import be.fgov.ehealth.mycarenet.commons.core.v3.RoutingType;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationRequest;
import oasis.names.tc.saml._2_0.protocol.AttributeQuery;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedRequestObjectBuilderImpl
implements RequestObjectBuilder,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedRequestObjectBuilderImpl.class);

    @Override
    public MemberDataConsultationRequest buildConsultationRequest(boolean isTest, InputReference references, AttributeQuery attrQuery) throws TechnicalConnectorException, MemberDataBusinessConnectorException {
        this.checkParameterNotNull(references, "InputReference");
        this.checkParameterNotNull(references.getInputReference(), "Input reference");
        String detailId = "_" + IdGeneratorFactory.getIdGenerator((String)"uuid").generateId();
        byte[] attrQueryBytes = ConnectorXmlUtils.toByteArray((Object)attrQuery);
        BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder((String)"memberdata");
        BusinessContent businessContent = new BusinessContent();
        businessContent.setId(detailId);
        businessContent.setValue(attrQueryBytes);
        EncryptedKnownContent encryptedKnownContent = new EncryptedKnownContent();
        encryptedKnownContent.setReplyToEtk(KeyDepotManagerFactory.getKeyDepotManager().getETK(KeyDepotManager.EncryptionTokenType.HOLDER_OF_KEY).getEncoded());
        encryptedKnownContent.setBusinessContent(businessContent);
        try {
            attrQueryBytes = new MemberDataEncryptionUtil<EncryptedKnownContent>().handleEncryption(encryptedKnownContent, SessionUtil.getHolderOfKeyCrypto());
            if (attrQueryBytes != null && ConfigFactory.getConfigValidator().getBooleanProperty("be.ehealth.businessconnector.mycarenet.memberdatasync.builders.impl.dumpMessages", Boolean.valueOf(false)).booleanValue()) {
                LOG.debug("EncryptedRequestObjectBuilder : Created blob content: " + new String(attrQueryBytes));
            }
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, (Throwable)e, new Object[0]);
        }
        Blob blob = blobBuilder.build(attrQueryBytes, "none", detailId, "text/xml", "MDA", "encryptedForKnownBED");
        MemberDataConsultationRequest request = new MemberDataConsultationRequest();
        CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder((String)"memberdata");
        request.setCommonInput(CommonInputMapper.mapCommonInputType((CommonInput)commonBuilder.createCommonInput(McnConfigUtil.retrievePackageInfo((String)"memberdata"), isTest, references.getInputReference())));
        request.setId(IdGeneratorFactory.getIdGenerator((String)"xsid").generateId());
        request.setIssueInstant(new DateTime());
        request.setDetail(BlobMapper.mapBlobTypefromBlob((Blob)blob));
        new MemberDataXmlValidatorImpl().validate(request);
        return request;
    }

    private void checkParameterNotNull(Object references, String parameterName) throws MemberDataBusinessConnectorException {
        if (references == null) {
            throw new MemberDataBusinessConnectorException(MemberDataBusinessConnectorExceptionValues.PARAMETER_NULL, parameterName);
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{MemberDataConsultationRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CommonInputType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RoutingType.class});
    }
}

