/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.medadmin.session.impl;

import be.cin.mycarenet._1_0.carenet.types.MedAdminRequestList;
import be.cin.mycarenet._1_0.carenet.types.MedAdminResponseList;
import be.cin.mycarenet._1_0.carenet.types.SingleNurseContractualCareRequest;
import be.cin.mycarenet._1_0.carenet.types.SingleNurseContractualCareResponse;
import be.cin.mycarenet._1_0.carenet.types.SingleNurseContractualCareUpdate;
import be.cin.mycarenet._1_0.carenet.types.SinglePalliativeCareRequest;
import be.cin.mycarenet._1_0.carenet.types.SinglePalliativeCareResponse;
import be.cin.mycarenet._1_0.carenet.types.SingleSpecificTechnicalCareRequest;
import be.cin.mycarenet._1_0.carenet.types.SingleSpecificTechnicalCareResponse;
import be.cin.nip.async.generic.RejectInb;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedMsgResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedPostResponse;
import be.ehealth.businessconnector.genericasync.helper.DefaultCommonAsyncService;
import be.ehealth.businessconnector.genericasync.helper.GetHelper;
import be.ehealth.businessconnector.genericasync.helper.PostHelper;
import be.ehealth.businessconnector.medadmin.domain.M4ACnfXmlProcessedGetResponse;
import be.ehealth.businessconnector.medadmin.domain.M4ACnfXmlProcessedMsgResponse;
import be.ehealth.businessconnector.medadmin.domain.M4AXmlProcessedGetResponse;
import be.ehealth.businessconnector.medadmin.domain.M4AXmlProcessedMsgResponse;
import be.ehealth.businessconnector.medadmin.domain.RejectXmlProcessedGetResponse;
import be.ehealth.businessconnector.medadmin.domain.RejectXmlProcessedMsgResponse;
import be.ehealth.businessconnector.medadmin.session.MedAdminService;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import org.w3c.dom.Element;

public class MedadminServiceImpl
extends DefaultCommonAsyncService
implements MedAdminService {
    private static final Configuration config = ConfigFactory.getConfigValidator();
    private static final String PROJECT_NAME = "medadmin";
    private static final String PLATFORM_NAME = "mycarenet";
    public static final String M4A_XML = "M4A_XML";
    public static final String M4A_FLAT = "M4A_FLAT";
    public static final String M4A_CNF_FLAT = "M4A_CNF_FLAT";
    public static final String REJECT = "REJECT";
    public static final String SCHEMA_LOCATION = "/mycarenet-genasync/XSD/MyCareNet_MedAdmin.xsd";
    public static final String SCHEMA_LOCATION_REJECT = "/mycarenet-commons/XSD/Reject.xsd";
    private static final String GENERICASYNC = "genericasync.";
    private GetHelper getHelper = new GetHelper("medadmin");
    private PostHelper postHelper = new PostHelper("mycarenet", "medadmin");

    public MedadminServiceImpl() {
        super(PROJECT_NAME);
    }

    @Override
    public ProcessedPostResponse postM4AFlat(byte[] records, String recipient, InputReference inputReference) throws ConnectorException {
        return this.postHelper.post(records, M4A_FLAT, recipient, inputReference);
    }

    @Override
    public ProcessedGetResponse<byte[]> getM4AFlat(GetRequest request) throws ConnectorException {
        return this.getHelper.get(request, M4A_FLAT, byte[].class);
    }

    @Override
    public ProcessedPostResponse postMedAdminRequestList(MedAdminRequestList medAdminRequestList, String recipient, InputReference inputReference) throws ConnectorException {
        return this.postHelper.post((Object)medAdminRequestList, M4A_XML, SCHEMA_LOCATION, recipient, inputReference);
    }

    @Override
    public ProcessedPostResponse postSingleNurseContractualCareRequest(SingleNurseContractualCareRequest singleNurseContractualCareRequest, String recipient, InputReference inputReference) throws ConnectorException {
        return this.postHelper.post((Object)singleNurseContractualCareRequest, M4A_XML, SCHEMA_LOCATION, recipient, inputReference);
    }

    @Override
    public ProcessedPostResponse postSinglePalliativeCareRequest(SinglePalliativeCareRequest singlePalliativeCareRequest, String recipient, InputReference inputReference) throws ConnectorException {
        return this.postHelper.post((Object)singlePalliativeCareRequest, M4A_XML, SCHEMA_LOCATION, recipient, inputReference);
    }

    @Override
    public ProcessedPostResponse postSingleSpecificTechnicalCareRequest(SingleSpecificTechnicalCareRequest singleSpecificTechnicalCareRequest, String recipient, InputReference inputReference) throws ConnectorException {
        return this.postHelper.post((Object)singleSpecificTechnicalCareRequest, M4A_XML, SCHEMA_LOCATION, recipient, inputReference);
    }

    @Override
    public M4AXmlProcessedGetResponse getM4AXml(GetRequest request) throws ConnectorException {
        ProcessedGetResponse processedGetResponse = this.getHelper.get(request, M4A_XML, byte[].class);
        M4AXmlProcessedGetResponse medAdminProcessedGetResponse = new M4AXmlProcessedGetResponse();
        medAdminProcessedGetResponse.getTAckResponses().addAll(processedGetResponse.getTAckResponses());
        this.transformRawResponseToBusinessObjects((ProcessedGetResponse<byte[]>)processedGetResponse, medAdminProcessedGetResponse);
        return medAdminProcessedGetResponse;
    }

    public void transformRawResponseToBusinessObjects(ProcessedGetResponse<byte[]> processedGetResponse, M4AXmlProcessedGetResponse medAdminProcessedGetResponse) throws TechnicalConnectorException {
        for (ProcessedMsgResponse processedMsgResponse : processedGetResponse.getMsgResponses()) {
            M4AXmlProcessedMsgResponse adminProcessedMsgResponse = new M4AXmlProcessedMsgResponse(processedMsgResponse);
            medAdminProcessedGetResponse.getMsgResponses().add(adminProcessedMsgResponse);
            byte[] businessResponse = (byte[])processedMsgResponse.getBusinessResponse();
            String type = ((Element)ConnectorXmlUtils.toObject((byte[])businessResponse, Object.class)).getLocalName();
            if ("SingleNurseContractualCareResponse".equals(type)) {
                SingleNurseContractualCareResponse singleNurseContractualCareResponse = (SingleNurseContractualCareResponse)ConnectorXmlUtils.toObject((byte[])businessResponse, SingleNurseContractualCareResponse.class);
                this.validateAgainstXsd(singleNurseContractualCareResponse);
                adminProcessedMsgResponse.getSingleNurseContractualCareResponses().add(singleNurseContractualCareResponse);
                continue;
            }
            if ("SinglePalliativeCareResponse".equals(type)) {
                SinglePalliativeCareResponse singlePalliativeCareResponse = (SinglePalliativeCareResponse)ConnectorXmlUtils.toObject((byte[])businessResponse, SinglePalliativeCareResponse.class);
                this.validateAgainstXsd(singlePalliativeCareResponse);
                adminProcessedMsgResponse.getSinglePalliativeCareResponses().add(singlePalliativeCareResponse);
                continue;
            }
            if ("SingleSpecificTechnicalCareResponse".equals(type)) {
                SingleSpecificTechnicalCareResponse singleSpecificTechnicalCareResponse = (SingleSpecificTechnicalCareResponse)ConnectorXmlUtils.toObject((byte[])businessResponse, SingleSpecificTechnicalCareResponse.class);
                this.validateAgainstXsd(singleSpecificTechnicalCareResponse);
                adminProcessedMsgResponse.getSingleSpecificTechnicalCareResponses().add(singleSpecificTechnicalCareResponse);
                continue;
            }
            if ("SingleNurseContractualCareUpdate".equals(type)) {
                SingleNurseContractualCareUpdate singleNurseContractualCareUpdate = (SingleNurseContractualCareUpdate)ConnectorXmlUtils.toObject((byte[])businessResponse, SingleNurseContractualCareUpdate.class);
                this.validateAgainstXsd(singleNurseContractualCareUpdate);
                adminProcessedMsgResponse.getSingleNurseContractualCareUpdates().add(singleNurseContractualCareUpdate);
                continue;
            }
            if ("MedAdminResponseList".equals(type)) {
                MedAdminResponseList medAdminResponseList = (MedAdminResponseList)ConnectorXmlUtils.toObject((byte[])businessResponse, MedAdminResponseList.class);
                this.validateAgainstXsd(medAdminResponseList);
                for (Object o : medAdminResponseList.getSingleNurseContractualCareResponsesAndSingleNurseContractualCareUpdatesAndSinglePalliativeCareResponses()) {
                    if (o instanceof SingleNurseContractualCareResponse) {
                        adminProcessedMsgResponse.getSingleNurseContractualCareResponses().add((SingleNurseContractualCareResponse)o);
                        continue;
                    }
                    if (o instanceof SingleNurseContractualCareUpdate) {
                        adminProcessedMsgResponse.getSingleNurseContractualCareUpdates().add((SingleNurseContractualCareUpdate)o);
                        continue;
                    }
                    if (o instanceof SinglePalliativeCareResponse) {
                        adminProcessedMsgResponse.getSinglePalliativeCareResponses().add((SinglePalliativeCareResponse)o);
                        continue;
                    }
                    if (!(o instanceof SingleSpecificTechnicalCareResponse)) continue;
                    adminProcessedMsgResponse.getSingleSpecificTechnicalCareResponses().add((SingleSpecificTechnicalCareResponse)o);
                }
                continue;
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{"[" + type + "] is not a valid root element for the business response"});
        }
    }

    @Override
    public M4ACnfXmlProcessedGetResponse getM4ACnfXml(GetRequest request) throws ConnectorException {
        M4ACnfXmlProcessedGetResponse medAdminProcessedGetResponse = new M4ACnfXmlProcessedGetResponse();
        ProcessedGetResponse processedGetResponse = this.getHelper.get(request, "M4A_CNF_XML", byte[].class);
        medAdminProcessedGetResponse.getTAckResponses().addAll(processedGetResponse.getTAckResponses());
        this.transformRawResponseToBusinessObjects((ProcessedGetResponse<byte[]>)processedGetResponse, medAdminProcessedGetResponse);
        return medAdminProcessedGetResponse;
    }

    public void transformRawResponseToBusinessObjects(ProcessedGetResponse<byte[]> processedGetResponse, M4ACnfXmlProcessedGetResponse medAdminProcessedGetResponse) throws TechnicalConnectorException {
        for (ProcessedMsgResponse processedMsgResponse : processedGetResponse.getMsgResponses()) {
            M4ACnfXmlProcessedMsgResponse adminProcessedMsgResponse = new M4ACnfXmlProcessedMsgResponse(processedMsgResponse);
            medAdminProcessedGetResponse.getMsgResponses().add(adminProcessedMsgResponse);
            byte[] businessResponse = (byte[])processedMsgResponse.getBusinessResponse();
            String type = ((Element)ConnectorXmlUtils.toObject((byte[])businessResponse, Object.class)).getLocalName();
            if ("SingleNurseContractualCareRequest".equals(type)) {
                SingleNurseContractualCareRequest singleNurseContractualCareRequest = (SingleNurseContractualCareRequest)ConnectorXmlUtils.toObject((byte[])businessResponse, SingleNurseContractualCareRequest.class);
                this.validateAgainstXsd(singleNurseContractualCareRequest);
                adminProcessedMsgResponse.getSingleNurseContractualCareRequests().add(singleNurseContractualCareRequest);
                continue;
            }
            if ("SinglePalliativeCareRequest".equals(type)) {
                SinglePalliativeCareRequest singlePalliativeCareRequest = (SinglePalliativeCareRequest)ConnectorXmlUtils.toObject((byte[])businessResponse, SinglePalliativeCareRequest.class);
                this.validateAgainstXsd(singlePalliativeCareRequest);
                adminProcessedMsgResponse.getSinglePalliativeCareRequests().add(singlePalliativeCareRequest);
                continue;
            }
            if ("SingleSpecificTechnicalCareRequest".equals(type)) {
                SingleSpecificTechnicalCareRequest singleSpecificTechnicalCareRequest = (SingleSpecificTechnicalCareRequest)ConnectorXmlUtils.toObject((byte[])businessResponse, SingleSpecificTechnicalCareRequest.class);
                this.validateAgainstXsd(singleSpecificTechnicalCareRequest);
                adminProcessedMsgResponse.getSingleSpecificTechnicalCareRequests().add(singleSpecificTechnicalCareRequest);
                continue;
            }
            if ("MedAdminRequestList".equals(type)) {
                MedAdminRequestList medAdminRequestList = (MedAdminRequestList)ConnectorXmlUtils.toObject((byte[])businessResponse, MedAdminRequestList.class);
                this.validateAgainstXsd(medAdminRequestList);
                for (Object o : medAdminRequestList.getSingleNurseContractualCareRequestsAndSinglePalliativeCareRequestsAndSingleSpecificTechnicalCareRequests()) {
                    if (o instanceof SingleNurseContractualCareRequest) {
                        adminProcessedMsgResponse.getSingleNurseContractualCareRequests().add((SingleNurseContractualCareRequest)o);
                        continue;
                    }
                    if (o instanceof SinglePalliativeCareRequest) {
                        adminProcessedMsgResponse.getSinglePalliativeCareRequests().add((SinglePalliativeCareRequest)o);
                        continue;
                    }
                    if (!(o instanceof SingleSpecificTechnicalCareRequest)) continue;
                    adminProcessedMsgResponse.getSingleSpecificTechnicalCareRequests().add((SingleSpecificTechnicalCareRequest)o);
                }
                continue;
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{"[" + type + "] is not a valid root element for the business response"});
        }
    }

    public void validateAgainstXsd(Object object) throws TechnicalConnectorException {
        if (config.getBooleanProperty("genericasync.medadmin.validation.incoming.businessresponse", Boolean.valueOf(true)).booleanValue()) {
            ValidatorHelper.validate((Object)object, (String)SCHEMA_LOCATION);
        }
    }

    @Override
    public ProcessedGetResponse<byte[]> getM4ACnfFlat(GetRequest request) throws ConnectorException {
        return this.getHelper.get(request, M4A_CNF_FLAT, byte[].class);
    }

    @Override
    public RejectXmlProcessedGetResponse getRejected(GetRequest request) throws ConnectorException {
        RejectXmlProcessedGetResponse medAdminProcessedGetResponse = new RejectXmlProcessedGetResponse();
        ProcessedGetResponse processedGetResponse = this.getHelper.get(request, REJECT, byte[].class);
        medAdminProcessedGetResponse.getTAckResponses().addAll(processedGetResponse.getTAckResponses());
        this.transformRawResponseToBusinessObjects((ProcessedGetResponse<byte[]>)processedGetResponse, medAdminProcessedGetResponse);
        return medAdminProcessedGetResponse;
    }

    public void transformRawResponseToBusinessObjects(ProcessedGetResponse<byte[]> processedGetResponse, RejectXmlProcessedGetResponse medAdminProcessedGetResponse) throws TechnicalConnectorException {
        for (ProcessedMsgResponse processedMsgResponse : processedGetResponse.getMsgResponses()) {
            String type;
            RejectXmlProcessedMsgResponse adminProcessedMsgResponse = new RejectXmlProcessedMsgResponse(processedMsgResponse);
            medAdminProcessedGetResponse.getMsgResponses().add(adminProcessedMsgResponse);
            byte[] businessResponse = (byte[])processedMsgResponse.getBusinessResponse();
            String receivedXml = new String(businessResponse);
            if (receivedXml.contains("\u0000")) {
                receivedXml = receivedXml.replaceAll("\u0000", "");
            }
            if ("RejectInb".equals(type = ((Element)ConnectorXmlUtils.toObject((String)receivedXml, Object.class)).getLocalName())) {
                RejectInb rejectInbResponse = (RejectInb)ConnectorXmlUtils.toObject((String)receivedXml, RejectInb.class);
                if (config.getBooleanProperty("genericasync.medadmin.validation.incoming.businessresponse", Boolean.valueOf(true)).booleanValue()) {
                    ValidatorHelper.validate((Object)rejectInbResponse, (String)SCHEMA_LOCATION_REJECT);
                }
                adminProcessedMsgResponse.getRejectInbResponses().add(rejectInbResponse);
                continue;
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{"[" + type + "] is not a valid root element for the business response"});
        }
    }
}

