/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetdomaincommons.builders.impl;

import be.ehealth.business.mycarenetdomaincommons.builders.impl.AbstractCommonBuilderImpl;
import be.ehealth.business.mycarenetdomaincommons.builders.util.CareProviderBuilder;
import be.ehealth.business.mycarenetdomaincommons.domain.CareProvider;
import be.ehealth.business.mycarenetdomaincommons.util.PropertyUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.util.ArrayList;
import java.util.Map;

public class GenericCommonBuilderImpl
extends AbstractCommonBuilderImpl {
    private static final String VALUE = ".value";
    private static final String QUALITY = ".quality";
    private static final String PHYSICALPERSON = ".physicalperson";
    private static final String CAREPROVIDER = ".careprovider";
    private ConfigValidator config;

    @Override
    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        if (parameterMap == null || parameterMap.isEmpty() || !parameterMap.containsKey("projectName")) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, new Object[]{"missing config parameters for initialize of CommonBuilder , check factory method call"});
        }
        this.projectName = (String)parameterMap.get("projectName");
        ArrayList<String> expectedProperties = new ArrayList<String>();
        String careProviderIdKey = "mycarenet." + PropertyUtil.retrieveProjectNameToUse(this.projectName, "mycarenet..") + CAREPROVIDER + ".nihii" + VALUE;
        String careProviderQualityKey = "mycarenet." + PropertyUtil.retrieveProjectNameToUse(this.projectName, "mycarenet..") + CAREPROVIDER + ".nihii" + QUALITY;
        expectedProperties.add(careProviderIdKey);
        expectedProperties.add(careProviderQualityKey);
        this.config = ConfigFactory.getConfigValidator(expectedProperties);
    }

    @Override
    protected CareProvider createCareProviderForOrigin() throws NumberFormatException, TechnicalConnectorException {
        String projectNameToUse = PropertyUtil.retrieveProjectNameToUse(this.projectName, "mycarenet..");
        String careProviderIdKey = "mycarenet." + projectNameToUse + CAREPROVIDER + ".nihii" + VALUE;
        String careProviderQualityKey = "mycarenet." + projectNameToUse + CAREPROVIDER + ".nihii" + QUALITY;
        CareProviderBuilder builder = new CareProviderBuilder(this.config.getProperty(careProviderQualityKey), this.config.getProperty(careProviderIdKey));
        String physicalPersonRootKey = "mycarenet." + projectNameToUse + CAREPROVIDER + PHYSICALPERSON;
        String organizationRootKey = "mycarenet." + projectNameToUse + CAREPROVIDER + ".organization";
        builder.addPhysicalPersonIdentification(this.createPerson(physicalPersonRootKey));
        builder.addOrganisationIdentification(this.createOrganization(organizationRootKey));
        return builder.build();
    }
}

