/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.v4.mapper;

import be.ehealth.business.mycarenetcommons.v4.mapper.CommonInputMapper;
import be.ehealth.business.mycarenetdomaincommons.domain.Actor;
import be.ehealth.business.mycarenetdomaincommons.domain.Attribute;
import be.ehealth.business.mycarenetdomaincommons.domain.CareProvider;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Identification;
import be.ehealth.business.mycarenetdomaincommons.domain.Identifier;
import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.business.mycarenetdomaincommons.domain.Origin;
import be.ehealth.business.mycarenetdomaincommons.domain.Party;
import be.ehealth.business.mycarenetdomaincommons.domain.Reference;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.fgov.ehealth.mycarenet.commons.core.v4.ActorType;
import be.fgov.ehealth.mycarenet.commons.core.v4.AttributeType;
import be.fgov.ehealth.mycarenet.commons.core.v4.CareProviderType;
import be.fgov.ehealth.mycarenet.commons.core.v4.CommonInputType;
import be.fgov.ehealth.mycarenet.commons.core.v4.IdType;
import be.fgov.ehealth.mycarenet.commons.core.v4.LicenseType;
import be.fgov.ehealth.mycarenet.commons.core.v4.NihiiType;
import be.fgov.ehealth.mycarenet.commons.core.v4.OriginType;
import be.fgov.ehealth.mycarenet.commons.core.v4.PackageType;
import be.fgov.ehealth.mycarenet.commons.core.v4.PartyType;
import be.fgov.ehealth.mycarenet.commons.core.v4.ReferenceType;
import be.fgov.ehealth.mycarenet.commons.core.v4.RequestType;
import be.fgov.ehealth.mycarenet.commons.core.v4.ValueRefString;
import java.util.ArrayList;
import java.util.List;

public class CommonInputMapperImpl
extends CommonInputMapper {
    @Override
    public CommonInputType map(CommonInput input) {
        List<AttributeType> list1;
        List<ReferenceType> list;
        if (input == null) {
            return null;
        }
        CommonInputType commonInputType = new CommonInputType();
        commonInputType.setRequest(this.commonInputToRequestType(input));
        commonInputType.setOrigin(this.map(input.getOrigin()));
        commonInputType.setInputReference(input.getInputReference());
        if (commonInputType.getReferences() != null && (list = this.referenceListToReferenceTypeList(input.getReferences())) != null) {
            commonInputType.getReferences().addAll(list);
        }
        if (commonInputType.getAttributes() != null && (list1 = this.attributeListToAttributeTypeList(input.getAttributes())) != null) {
            commonInputType.getAttributes().addAll(list1);
        }
        return commonInputType;
    }

    @Override
    public OriginType map(Origin input) {
        OriginType target;
        List<ActorType> list;
        if (input == null) {
            return null;
        }
        OriginType originType = new OriginType();
        originType.setSiteID(this.originToValueRefString(input));
        originType.setPackage(this.map(input.getPackageInfo()));
        originType.setCareProvider(this.map(input.getCareProvider()));
        originType.setSender(this.map(input.getSender()));
        if (originType.getActors() != null && (list = this.actorListToActorTypeList(input.getActors())) != null) {
            originType.getActors().addAll(list);
        }
        if ((target = this.doAfterMapping(originType)) != null) {
            return target;
        }
        return originType;
    }

    @Override
    public PackageType map(PackageInfo input) {
        if (input == null) {
            return null;
        }
        PackageType packageType = new PackageType();
        packageType.setName(this.packageInfoToValueRefString(input));
        packageType.setLicense(this.packageInfoToLicenseType(input));
        PackageType target = this.doAfterMapping(packageType);
        if (target != null) {
            return target;
        }
        return packageType;
    }

    @Override
    public CareProviderType map(CareProvider input) {
        if (input == null) {
            return null;
        }
        CareProviderType careProviderType = new CareProviderType();
        careProviderType.setNihii(this.map(input.getNihii()));
        careProviderType.setPhysicalPerson(this.map(input.getPhysicalPerson()));
        careProviderType.setOrganization(this.map(input.getOrganization()));
        return careProviderType;
    }

    @Override
    public NihiiType map(Nihii input) {
        if (input == null) {
            return null;
        }
        NihiiType nihiiType = new NihiiType();
        nihiiType.setValue(this.nihiiToValueRefString(input));
        nihiiType.setQuality(input.getQuality());
        NihiiType target = this.doAfterMapping(nihiiType);
        if (target != null) {
            return target;
        }
        return nihiiType;
    }

    @Override
    public IdType map(Identification input) {
        if (input == null) {
            return null;
        }
        IdType idType = new IdType();
        idType.setName(this.identificationToValueRefString(input));
        idType.setSsin(this.identificationToValueRefString1(input));
        idType.setCbe(this.identificationToValueRefString2(input));
        idType.setNihii(this.map(input.getNihii()));
        IdType target = this.doAfterMapping(idType);
        if (target != null) {
            return target;
        }
        return idType;
    }

    @Override
    public PartyType map(Party input) {
        if (input == null) {
            return null;
        }
        PartyType partyType = new PartyType();
        partyType.setPhysicalPerson(this.map(input.getPhysicalPerson()));
        partyType.setOrganization(this.map(input.getOrganization()));
        return partyType;
    }

    @Override
    public ReferenceType map(Reference input) {
        if (input == null) {
            return null;
        }
        ReferenceType referenceType = new ReferenceType();
        referenceType.setValue(input.getValue());
        referenceType.setType(input.getType());
        return referenceType;
    }

    @Override
    public AttributeType map(Attribute input) {
        if (input == null) {
            return null;
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setValue(input.getValue());
        attributeType.setKey(input.getKey());
        return attributeType;
    }

    protected RequestType commonInputToRequestType(CommonInput commonInput) {
        if (commonInput == null) {
            return null;
        }
        RequestType requestType = new RequestType();
        if (commonInput.isTest() != null) {
            requestType.setIsTest(commonInput.isTest().booleanValue());
        }
        return requestType;
    }

    protected List<ReferenceType> referenceListToReferenceTypeList(List<Reference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ReferenceType> list1 = new ArrayList<ReferenceType>(list.size());
        for (Reference reference : list) {
            list1.add(this.map(reference));
        }
        return list1;
    }

    protected List<AttributeType> attributeListToAttributeTypeList(List<Attribute> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AttributeType> list1 = new ArrayList<AttributeType>(list.size());
        for (Attribute attribute : list) {
            list1.add(this.map(attribute));
        }
        return list1;
    }

    protected ValueRefString originToValueRefString(Origin origin) {
        if (origin == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(origin.getSiteId());
        return valueRefString;
    }

    protected be.fgov.ehealth.mycarenet.commons.core.v4.Identifier identifierToIdentifier(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        be.fgov.ehealth.mycarenet.commons.core.v4.Identifier identifier1 = new be.fgov.ehealth.mycarenet.commons.core.v4.Identifier();
        identifier1.setValue(identifier.getValue());
        identifier1.setType(identifier.getType());
        return identifier1;
    }

    protected List<be.fgov.ehealth.mycarenet.commons.core.v4.Identifier> identifierListToIdentifierList(List<Identifier> list) {
        if (list == null) {
            return null;
        }
        ArrayList<be.fgov.ehealth.mycarenet.commons.core.v4.Identifier> list1 = new ArrayList<be.fgov.ehealth.mycarenet.commons.core.v4.Identifier>(list.size());
        for (Identifier identifier : list) {
            list1.add(this.identifierToIdentifier(identifier));
        }
        return list1;
    }

    protected ActorType actorToActorType(Actor actor) {
        List<AttributeType> list1;
        List<be.fgov.ehealth.mycarenet.commons.core.v4.Identifier> list;
        if (actor == null) {
            return null;
        }
        ActorType actorType = new ActorType();
        actorType.setType(actor.getType());
        actorType.setSubType(actor.getSubType());
        actorType.setRole(actor.getRole());
        if (actorType.getIdentifiers() != null && (list = this.identifierListToIdentifierList(actor.getIdentifiers())) != null) {
            actorType.getIdentifiers().addAll(list);
        }
        if (actorType.getAttributes() != null && (list1 = this.attributeListToAttributeTypeList(actor.getAttributes())) != null) {
            actorType.getAttributes().addAll(list1);
        }
        return actorType;
    }

    protected List<ActorType> actorListToActorTypeList(List<Actor> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ActorType> list1 = new ArrayList<ActorType>(list.size());
        for (Actor actor : list) {
            list1.add(this.actorToActorType(actor));
        }
        return list1;
    }

    protected ValueRefString packageInfoToValueRefString(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(packageInfo.getPackageName());
        return valueRefString;
    }

    protected LicenseType packageInfoToLicenseType(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        LicenseType licenseType = new LicenseType();
        licenseType.setUsername(packageInfo.getUserName());
        licenseType.setPassword(packageInfo.getPassword());
        return licenseType;
    }

    protected ValueRefString nihiiToValueRefString(Nihii nihii) {
        if (nihii == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(nihii.getValue());
        return valueRefString;
    }

    protected ValueRefString identificationToValueRefString(Identification identification) {
        if (identification == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(identification.getName());
        return valueRefString;
    }

    protected ValueRefString identificationToValueRefString1(Identification identification) {
        if (identification == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(identification.getSsin());
        return valueRefString;
    }

    protected ValueRefString identificationToValueRefString2(Identification identification) {
        if (identification == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(identification.getCbe());
        return valueRefString;
    }
}

