/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.validator;

import be.ehealth.business.mycarenetcommons.exception.ConnectorValidationException;
import be.ehealth.business.mycarenetcommons.exception.ValidationError;
import be.ehealth.business.mycarenetcommons.validator.AbstractMyCarenetValidator;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType;
import java.util.ArrayList;
import java.util.List;

public class CommonOutputValidator
extends AbstractMyCarenetValidator
implements ConfigurationModuleBootstrap.ModuleBootstrapHook {
    public static void validate(CommonOutputType commonOutput) throws ConnectorValidationException {
        String currentPath = "commonOnput";
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (commonOutput != null) {
            CommonOutputValidator.validateReference(errors, CommonOutputValidator.addPath(currentPath, "InputReference"), commonOutput.getInputReference());
            CommonOutputValidator.validateReference(errors, CommonOutputValidator.addPath(currentPath, "NIPReference"), commonOutput.getNIPReference());
            CommonOutputValidator.validateReference(errors, CommonOutputValidator.addPath(currentPath, "OutputReference"), commonOutput.getOutputReference());
            if (!errors.isEmpty()) {
                throw new ConnectorValidationException(errors);
            }
        } else {
            errors.add(new ValidationError(currentPath, "the " + currentPath + " is null"));
            throw new ConnectorValidationException(errors);
        }
    }

    private static void validateReference(List<ValidationError> errors, String path, String inputReference) {
        if (inputReference == null) {
            errors.add(new ValidationError(path, "the " + path + " is null"));
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CommonOutputType.class});
    }
}

