/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.util;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.handler.domain.WsAddressingHeader;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import java.net.URI;
import java.net.URISyntaxException;

public class WsAddressingUtil {
    public static WsAddressingHeader createHeader(String mutualityToSendTo, String action) throws TechnicalConnectorException {
        return WsAddressingUtil.createHeader(mutualityToSendTo, action, null);
    }

    public static WsAddressingHeader createHeader(String mutualityToSendTo, String action, String messageId) throws TechnicalConnectorException {
        try {
            WsAddressingHeader getHeader = null;
            getHeader = action == null ? new WsAddressingHeader(new URI("")) : new WsAddressingHeader(new URI(action));
            getHeader.setFaultTo("http://www.w3.org/2005/08/addressing/anonymous");
            getHeader.setReplyTo("http://www.w3.org/2005/08/addressing/anonymous");
            if (messageId == null) {
                getHeader.setMessageID(new URI(IdGeneratorFactory.getIdGenerator((String)"uuid").generateId()));
            } else {
                getHeader.setMessageID(new URI(messageId));
            }
            if (mutualityToSendTo == null) {
                getHeader.setTo(new URI(""));
            } else {
                getHeader.setTo(new URI("urn:nip:destination:io:" + mutualityToSendTo));
            }
            return getHeader;
        }
        catch (URISyntaxException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

