/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import be.ehealth.business.mycarenetcommons.builders.ResponseBuilder;
import be.ehealth.business.mycarenetcommons.builders.impl.BuilderUtils;
import be.ehealth.business.mycarenetcommons.domain.Blob;
import be.ehealth.business.mycarenetcommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetcommons.exception.InvalidBlobContentConnectorExceptionValues;
import be.ehealth.business.mycarenetcommons.validator.CommonOutputValidator;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.mycarenet.commons.core.v2.BlobType;
import be.fgov.ehealth.mycarenet.commons.protocol.v2.SendRequestType;
import be.fgov.ehealth.mycarenet.commons.protocol.v2.SendResponseType;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.util.HashMap;
import java.util.Map;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;
import org.apache.commons.lang.ArrayUtils;
import org.etsi.uri._01903.v1_3.QualifyingProperties;
import org.etsi.uri._01903.v1_3.UnsignedProperties;
import org.w3._2005._05.xmlmime.Base64Binary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ResponseBuilderImpl
implements ResponseBuilder,
ConfigurableImplementation,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static ResponseBuilderImpl instance;
    private String projectName;

    public static ResponseBuilder getInstance() {
        if (instance == null) {
            instance = new ResponseBuilderImpl();
        }
        return instance;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        if (parameterMap == null || parameterMap.isEmpty() || !parameterMap.containsKey("projectname")) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, new Object[]{"missing config parameters for initialize of CommonBuilder , check factory method call"});
        }
        this.projectName = (String)parameterMap.get("projectname");
    }

    @Override
    public void validateHash(Blob blob) throws TechnicalConnectorException {
        this.checkIfInitialized();
        byte[] decompressedBlob = BuilderUtils.decompressBlob(blob.getContent(), blob.getContentEncoding());
        BuilderUtils.checkHash(blob.getHashValue(), decompressedBlob);
    }

    private void checkIfInitialized() throws IllegalStateException {
        if (this.projectName == null) {
            throw new IllegalStateException("method on " + this.getClass().getCanonicalName() + " called while it was not initialized yet ");
        }
    }

    @Override
    @Deprecated
    public void validateXades(SendResponseType responseType, Blob blob) throws TechnicalConnectorException {
        this.commonValidateMethod(responseType, blob);
    }

    private void commonValidateMethod(SendResponseType responseType, Blob blob) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        this.checkIfInitialized();
        String neededXadesLevel = this.retrieveResponseXadesProperty();
        Base64Binary xades = null;
        if (responseType != null && responseType.getReturn() != null) {
            xades = responseType.getReturn().getXadesT();
        }
        if (xades == null || xades.getValue() == null || ArrayUtils.isEmpty((byte[])xades.getValue())) {
            if (!this.isXadesOptional()) {
                throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.XADESVALUE_NULL, blob);
            }
        } else {
            byte[] xadesByteArray = ArrayUtils.clone((byte[])xades.getValue());
            AdvancedElectronicSignatureEnumeration xadesSignatureType = this.convertToSignatureType(neededXadesLevel);
            SignatureBuilder builder = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)xadesSignatureType);
            Element sigElement = ConnectorXmlUtils.toElement((byte[])xadesByteArray);
            HashMap optionMap = new HashMap();
            SignatureVerificationResult result = builder.verify(this.reassemblyMessage(responseType, sigElement), xadesByteArray, optionMap);
            if (result.getErrors().size() != 0) {
                this.createInvalidBlobContentConnectorException(blob, result, xades);
            }
        }
    }

    public void createInvalidBlobContentConnectorException(Blob blob, SignatureVerificationResult result, Base64Binary xades) throws InvalidBlobContentConnectorException {
        StringBuilder errorMessageBuilder = new StringBuilder();
        for (SignatureVerificationError verificationError : result.getErrors()) {
            errorMessageBuilder.append("error: ").append(verificationError.getErrorName()).append(":[").append(verificationError.getMessage()).append("]");
        }
        String receivedXadesString = xades != null && xades.getValue() != null ? new String(xades.getValue()) : "";
        throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.XADESVALUES_DIFFERENT, blob, errorMessageBuilder.toString(), receivedXadesString);
    }

    @Override
    public void validateXades(SendResponseType responseType) throws TechnicalConnectorException {
        Blob blob = this.mapBlobTypeToBlob(responseType.getReturn().getDetail());
        this.commonValidateMethod(responseType, blob);
    }

    private AdvancedElectronicSignatureEnumeration convertToSignatureType(String xadesRequiredProperty) {
        if ("xadest".equals(xadesRequiredProperty)) {
            return AdvancedElectronicSignatureEnumeration.XAdES_T;
        }
        if ("xades".equals(xadesRequiredProperty)) {
            return AdvancedElectronicSignatureEnumeration.XAdES;
        }
        throw new IllegalArgumentException("no AdvancedElectronicSignatureEnumeration known for config parameter 'mycarenet." + this.projectName + ".response.requiredxades' with value " + xadesRequiredProperty);
    }

    private boolean isXadesOptional() {
        String xadesRequiredProperty = this.retrieveResponseXadesProperty();
        return "none".equals(xadesRequiredProperty);
    }

    public String retrieveResponseXadesProperty() {
        return ConfigFactory.getConfigValidator().getProperty("mycarenet." + this.projectName + ".response.neededxadeslevel", "xades");
    }

    @Override
    public String getResponse(SendResponseType responseType) throws TechnicalConnectorException {
        return this.getResponse(responseType, true);
    }

    @Override
    public String getResponse(SendResponseType responseType, boolean validate) throws TechnicalConnectorException {
        Blob blob = this.mapBlobTypeToBlob(responseType.getReturn().getDetail());
        if (validate) {
            CommonOutputValidator.validate(responseType.getReturn().getCommonOutput());
            this.validateHash(blob);
            this.validateXades(responseType, blob);
        }
        return new String(BuilderUtils.decompressBlob(blob.getContent(), blob.getContentEncoding()));
    }

    public Blob mapBlobTypeToBlob(BlobType inBlob) {
        Blob blob = new Blob();
        blob.setId(inBlob.getId());
        blob.setContent(inBlob.getValue());
        blob.setHashValue(inBlob.getHashValue());
        blob.setContentEncoding(inBlob.getContentEncoding());
        blob.setContentType(inBlob.getContentType());
        return blob;
    }

    private byte[] reassemblyMessage(Object responseObject, Element sigElement) throws TechnicalConnectorException {
        MarshallerHelper responseMarshaller = new MarshallerHelper(responseObject.getClass(), responseObject.getClass());
        Document explodedDoc = responseMarshaller.toDocument(responseObject);
        explodedDoc.adoptNode(sigElement);
        Element el = explodedDoc.createElement("XadesT-Signature");
        el.appendChild(sigElement);
        ConnectorXmlUtils.getFirstChildElement((Node)explodedDoc).appendChild(el);
        return ConnectorXmlUtils.toByteArray((Node)explodedDoc);
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{BlobType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendResponseType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SignResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{UnsignedProperties.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SignRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{QualifyingProperties.class});
    }
}

