/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import be.ehealth.business.mycarenetcommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetcommons.exception.InvalidBlobContentConnectorExceptionValues;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuilderUtils {
    private static Logger logger = LoggerFactory.getLogger(BuilderUtils.class);

    private BuilderUtils() {
    }

    public static byte[] checkAndDecompress(byte[] content, String contentEncoding, byte[] blobHashValue, boolean hashTagRequired) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        if (content == null || ArrayUtils.isEmpty((byte[])content)) {
            throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.PARAMETER_NULL, null, "The content of the blob");
        }
        byte[] decompressedBlob = BuilderUtils.decompressBlob(content, contentEncoding);
        if (blobHashValue != null && blobHashValue.length > 0) {
            BuilderUtils.checkHash(blobHashValue, decompressedBlob);
        } else if (hashTagRequired) {
            throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.HASHVALUE_NULL, decompressedBlob);
        }
        return decompressedBlob;
    }

    public static void checkHash(byte[] blobHashValue, byte[] decompressedBlob) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        try {
            byte[] calculatedHashValue = BuilderUtils.buildHash(decompressedBlob);
            if (!Arrays.areEqual((byte[])blobHashValue, (byte[])calculatedHashValue)) {
                String blobHashAsString = blobHashValue != null ? new String(Base64.encode((byte[])blobHashValue)) : "";
                String calculatedHashAsString = calculatedHashValue != null ? new String(Base64.encode((byte[])calculatedHashValue)) : "";
                throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.HASH_VALUES_DIFFERENT, null, decompressedBlob, new Object[]{blobHashAsString, calculatedHashAsString});
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static byte[] decompressBlob(byte[] decompressedBlob, String contentEncoding) {
        block5: {
            if ("none".equals(contentEncoding)) {
                logger.warn("decompressBlob called with on blob with contentEncoding " + contentEncoding + " : decompress will be skipped!");
            } else {
                try {
                    decompressedBlob = ConnectorIOUtils.decompress((byte[])decompressedBlob);
                    if (!contentEncoding.equals("deflate")) {
                        logger.warn("Blob was flagged as not deflated but was.");
                    }
                }
                catch (TechnicalConnectorException e) {
                    if (!contentEncoding.equals("deflate")) break block5;
                    logger.warn("Blob was flagged as deflated but wasn't.");
                }
            }
        }
        return decompressedBlob;
    }

    public static byte[] buildHash(byte[] decompressedBlob) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(decompressedBlob);
        return md.digest();
    }
}

