/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.mapper;

import be.ehealth.business.mycarenetcommons.domain.Blob;
import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.business.mycarenetcommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetcommons.domain.CommonInput;
import be.ehealth.business.mycarenetcommons.domain.Identification;
import be.ehealth.business.mycarenetcommons.domain.Nihii;
import be.ehealth.business.mycarenetcommons.domain.Party;
import be.ehealth.business.mycarenetcommons.domain.Period;
import be.ehealth.business.mycarenetcommons.domain.Routing;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ByteArrayDatasource;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.mycarenet.commons.core.v2.BlobType;
import be.fgov.ehealth.mycarenet.commons.core.v2.CareProviderType;
import be.fgov.ehealth.mycarenet.commons.core.v2.CareReceiverIdType;
import be.fgov.ehealth.mycarenet.commons.core.v2.CommonInputType;
import be.fgov.ehealth.mycarenet.commons.core.v2.IdType;
import be.fgov.ehealth.mycarenet.commons.core.v2.LicenseType;
import be.fgov.ehealth.mycarenet.commons.core.v2.NihiiType;
import be.fgov.ehealth.mycarenet.commons.core.v2.OriginType;
import be.fgov.ehealth.mycarenet.commons.core.v2.PackageType;
import be.fgov.ehealth.mycarenet.commons.core.v2.PartyType;
import be.fgov.ehealth.mycarenet.commons.core.v2.PeriodType;
import be.fgov.ehealth.mycarenet.commons.core.v2.RequestType;
import be.fgov.ehealth.mycarenet.commons.core.v2.RoutingType;
import be.fgov.ehealth.mycarenet.commons.core.v2.ValueRefString;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.io.IOUtils;
import org.w3._2005._05.xmlmime.Base64Binary;

public final class SendRequestMapper
implements ConfigurationModuleBootstrap.ModuleBootstrapHook {
    public static CommonInputType mapCommonInput(CommonInput commonInput) {
        CommonInputType inputType = new CommonInputType();
        inputType.setOrigin(SendRequestMapper.getOrigin(commonInput));
        inputType.setInputReference(commonInput.getInputReference());
        inputType.setRequest(SendRequestMapper.getRequestType(commonInput.isTest()));
        return inputType;
    }

    public static RoutingType mapRouting(Routing inRouting) {
        RoutingType routing = new RoutingType();
        routing.setCareReceiver(SendRequestMapper.getCareReceiver(inRouting.getCareReceiver()));
        routing.setPeriod(SendRequestMapper.getPeriod(inRouting.getPeriod()));
        routing.setReferenceDate(inRouting.getReferenceDate());
        return routing;
    }

    public static BlobType mapBlobToBlobType(Blob inBlob) {
        BlobType blob = new BlobType();
        blob.setId(inBlob.getId());
        blob.setValue(inBlob.getContent());
        blob.setHashValue(inBlob.getHashValue());
        blob.setContentEncoding(inBlob.getContentEncoding());
        blob.setContentType(inBlob.getContentType());
        return blob;
    }

    public static Blob mapBlobTypeToBlob(BlobType inBlob) {
        Blob blob = new Blob();
        blob.setId(inBlob.getId());
        blob.setContent(inBlob.getValue());
        blob.setHashValue(inBlob.getHashValue());
        blob.setContentEncoding(inBlob.getContentEncoding());
        blob.setContentType(inBlob.getContentType());
        return blob;
    }

    private static OriginType getOrigin(CommonInput commonInput) {
        OriginType origin = new OriginType();
        origin.setCareProvider(SendRequestMapper.getCareprovider(commonInput.getOrigin().getCareProvider()));
        origin.setPackage(SendRequestMapper.getPackage(commonInput.getOrigin().getPackageInfo()));
        origin.setSender(SendRequestMapper.getParty(commonInput.getOrigin().getSender()));
        return origin;
    }

    private static CareProviderType getCareprovider(CareProvider inProvider) {
        CareProviderType careProvider = new CareProviderType();
        careProvider.setNihii(SendRequestMapper.getNihii(inProvider.getNihii()));
        careProvider.setOrganization(SendRequestMapper.getIdType(inProvider.getOrganization()));
        careProvider.setPhysicalPerson(SendRequestMapper.getIdType(inProvider.getPhysicalPerson()));
        return careProvider;
    }

    private static RequestType getRequestType(boolean isTest) {
        RequestType requestType = new RequestType();
        requestType.setIsTest(isTest);
        return requestType;
    }

    private static CareReceiverIdType getCareReceiver(CareReceiverId inCareReceiver) {
        CareReceiverIdType careReceiver = new CareReceiverIdType();
        careReceiver.setMutuality(inCareReceiver.getMutuality());
        careReceiver.setRegNrWithMut(inCareReceiver.getRegistrationNumberWithMutuality());
        careReceiver.setSsin(inCareReceiver.getSsinNumber());
        return careReceiver;
    }

    private static PackageType getPackage(PackageInfo info) {
        PackageType type = new PackageType();
        type.setName(SendRequestMapper.getValueRef(info.getPackageName(), null));
        type.setLicense(SendRequestMapper.getLicense(info.getUserName(), info.getPassword()));
        return type;
    }

    private static NihiiType getNihii(Nihii inNihii) {
        NihiiType nihii = null;
        if (inNihii != null) {
            nihii = new NihiiType();
            nihii.setValue(SendRequestMapper.getValueRef(inNihii.getValue(), null));
            nihii.setQuality(inNihii.getQuality());
        }
        return nihii;
    }

    private static IdType getIdType(Identification id) {
        IdType idType = null;
        if (id != null) {
            idType = new IdType();
            idType.setCbe(SendRequestMapper.getValueRef(id.getCbe(), null));
            idType.setName(SendRequestMapper.getValueRef(id.getName(), null));
            idType.setSsin(SendRequestMapper.getValueRef(id.getSsin(), null));
            idType.setNihii(SendRequestMapper.getNihii(id.getNihii()));
        }
        return idType;
    }

    private static ValueRefString getValueRef(String value, String reference) {
        ValueRefString valueRef = null;
        if (value != null) {
            valueRef = new ValueRefString();
            valueRef.setValue(value);
            valueRef.setValueRef(reference);
        }
        return valueRef;
    }

    private static LicenseType getLicense(String userName, String password) {
        LicenseType license = new LicenseType();
        license.setUsername(userName);
        license.setPassword(password);
        return license;
    }

    private static PartyType getParty(Party inParty) {
        PartyType party = new PartyType();
        party.setOrganization(SendRequestMapper.getIdType(inParty.getOrganization()));
        party.setPhysicalPerson(SendRequestMapper.getIdType(inParty.getPhysicalPerson()));
        return party;
    }

    private static PeriodType getPeriod(Period inPeriod) {
        PeriodType period = null;
        if (inPeriod != null) {
            period = new PeriodType();
            period.setStart(inPeriod.getBegin());
            period.setEnd(inPeriod.getEnd());
        }
        return period;
    }

    public static Blob mapToBlob(be.cin.types.v1.Blob blob) throws TechnicalConnectorException {
        Blob result = new Blob();
        result.setContent(SendRequestMapper.convertToByteArray(blob.getValue()));
        result.setId(blob.getId());
        result.setContentEncoding(blob.getContentEncoding());
        result.setHashValue(blob.getHashValue());
        result.setContentType(blob.getContentType());
        return result;
    }

    public static be.cin.types.v1.Blob mapBlobToCinBlob(Blob blob) {
        be.cin.types.v1.Blob result = new be.cin.types.v1.Blob();
        ByteArrayDatasource rawData = new ByteArrayDatasource(blob.getContent());
        DataHandler dh = new DataHandler((DataSource)rawData);
        result.setValue(dh);
        result.setMessageName(blob.getMessageName());
        result.setId(blob.getId());
        result.setContentEncoding(blob.getContentEncoding());
        result.setHashValue(blob.getHashValue());
        result.setContentType(blob.getContentType());
        return result;
    }

    public static Base64Binary mapB64fromByte(byte[] param) {
        Base64Binary result = new Base64Binary();
        result.setValue(param);
        result.setContentType("text/xml");
        return result;
    }

    private static byte[] convertToByteArray(DataHandler value) throws TechnicalConnectorException {
        if (value == null) {
            return new byte[0];
        }
        try {
            return IOUtils.toByteArray((InputStream)value.getInputStream());
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNKNOWN_ERROR, new Object[]{"IoException while converting dataHandler to byteArray", e});
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{BlobType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CareProviderType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CareReceiverIdType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CommonInputType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{IdType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{LicenseType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{NihiiType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{OriginType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PackageType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PartyType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PeriodType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RoutingType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ValueRefString.class});
    }
}

