/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.mediprimav2.service;

import be.ehealth.business.common.util.HandlerChainUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import org.apache.commons.lang.Validate;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_CONSULTATION_MEDIPRIMA = "endpoint.mediprimav2.consultation";
    private static final String PROP_VALIDATION_INCOMING_MEDIPRIMA = "validation.incoming.message.mediprimav2.consultation";
    public static final String MEDIPRIMA_XSD = "/ehealth-mediprima/XSD/ehealth-mediprima-protocol-2_0.xsd";
    private static Configuration config = ConfigFactory.getConfigValidator();

    private ServiceFactory() {
        throw new UnsupportedOperationException("class may not be initialized, only static methods should be used");
    }

    public static GenericRequest getMediprimaConsultationService(SAMLToken token, String soapAction) throws TechnicalConnectorException {
        Validate.notNull((Object)token, (String)"Required parameter SAMLToken is null.");
        Validate.notNull((Object)token, (String)"Required parameter soapAction is null.");
        return new GenericRequest().setEndpoint(config.getProperty(PROP_ENDPOINT_CONSULTATION_MEDIPRIMA, "$uddi{uddi:ehealth-fgov-be:business:mediprimaconsult:v2}")).setCredential((Credential)token, TokenType.SAML).setSoapAction(soapAction).addDefaulHandlerChain().addHandlerChain(HandlerChainUtil.buildChainWithValidator((String)PROP_VALIDATION_INCOMING_MEDIPRIMA, (String[])new String[]{MEDIPRIMA_XSD}));
    }
}

