/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hub.util;

import be.ehealth.business.kmehrcommons.HcPartyUtil;
import be.ehealth.business.kmehrcommons.builders.Cd;
import be.ehealth.business.kmehrcommons.builders.Id;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.hubservices.core.v1.RequestType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTypeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RequestTypeBuilder.class);
    private RequestType request;

    public static RequestTypeBuilder init() throws TechnicalConnectorException {
        RequestTypeBuilder requestTypeBuilder = new RequestTypeBuilder();
        RequestType newRequest = new RequestType();
        newRequest.setDate(new DateTime());
        newRequest.setTime(new DateTime());
        newRequest.setId(HcPartyUtil.createKmehrId((String)"intrahub", (String)SessionUtil.getNihii()));
        requestTypeBuilder.request = newRequest;
        return requestTypeBuilder;
    }

    public RequestTypeBuilder addGenericAuthor() throws TechnicalConnectorException {
        this.request.setAuthor(HcPartyUtil.createAuthor((String)"intrahub"));
        return this;
    }

    public RequestTypeBuilder addAuthorWithEncryptionInformation() throws TechnicalConnectorException {
        AuthorType author = HcPartyUtil.createAuthor((String)"intrahub");
        this.addSecurityTags(author);
        this.request.setAuthor(author);
        return this;
    }

    private void addSecurityTags(AuthorType author) throws TechnicalConnectorException {
        boolean found = false;
        for (HcpartyType party : author.getHcparties()) {
            for (CDHCPARTY partyType : party.getCds()) {
                partyType.getValue().equalsIgnoreCase(HcPartyUtil.getAuthorKmehrQuality());
                found = true;
            }
            if (!found) continue;
            this.addEncryptionActorForNihiiOrNiss(party);
        }
    }

    public RequestType build() {
        return this.request;
    }

    private void addEncryptionActorForNihiiOrNiss(HcpartyType hcParty) throws TechnicalConnectorException {
        Id idBuilder = new Id().s(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR).sv("1.0");
        Cd cdBuilder = new Cd().s(CDHCPARTYschemes.CD_ENCRYPTION_ACTOR).sv("1.0");
        if (this.getNihii() == null) {
            idBuilder.value(SessionUtil.getNiss());
            cdBuilder.value(IdentifierType.SSIN.getType(48));
        } else {
            idBuilder.value(this.getNihii());
            cdBuilder.value(IdentifierType.NIHII.getType(48));
        }
        hcParty.getIds().add(idBuilder.build());
        hcParty.getCds().add(cdBuilder.build());
    }

    private String getNihii() {
        try {
            return SessionUtil.getNihii();
        }
        catch (TechnicalConnectorException e) {
            LOG.debug("Unable to obtain nihii. Reason: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private RequestTypeBuilder() {
    }
}

