/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hub.service.impl;

import be.ehealth.businessconnector.hub.exception.FolderDecryptionRuntimeException;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.businessconnector.hub.security.HubRequestDoctor;
import be.ehealth.businessconnector.hub.security.HubRequestHandler;
import be.ehealth.businessconnector.hub.security.HubRequestWithEncryption;
import be.ehealth.businessconnector.hub.service.IntraHubService;
import be.ehealth.businessconnector.hub.service.ServiceFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.hubservices.core.v1.DeclareTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.DeclareTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.GetAccessRightRequest;
import be.fgov.ehealth.hubservices.core.v1.GetAccessRightResponse;
import be.fgov.ehealth.hubservices.core.v1.GetHCPartyConsentRequest;
import be.fgov.ehealth.hubservices.core.v1.GetHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.GetHCPartyRequest;
import be.fgov.ehealth.hubservices.core.v1.GetHCPartyResponse;
import be.fgov.ehealth.hubservices.core.v1.GetPatientAuditTrailRequest;
import be.fgov.ehealth.hubservices.core.v1.GetPatientAuditTrailResponse;
import be.fgov.ehealth.hubservices.core.v1.GetPatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v1.GetPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.GetPatientRequest;
import be.fgov.ehealth.hubservices.core.v1.GetPatientResponse;
import be.fgov.ehealth.hubservices.core.v1.GetTherapeuticLinkRequest;
import be.fgov.ehealth.hubservices.core.v1.GetTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionListRequest;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionListResponse;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.PutAccessRightRequest;
import be.fgov.ehealth.hubservices.core.v1.PutAccessRightResponse;
import be.fgov.ehealth.hubservices.core.v1.PutHCPartyConsentRequest;
import be.fgov.ehealth.hubservices.core.v1.PutHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.PutHCPartyRequest;
import be.fgov.ehealth.hubservices.core.v1.PutHCPartyResponse;
import be.fgov.ehealth.hubservices.core.v1.PutPatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v1.PutPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.PutPatientRequest;
import be.fgov.ehealth.hubservices.core.v1.PutPatientResponse;
import be.fgov.ehealth.hubservices.core.v1.PutTherapeuticLinkRequest;
import be.fgov.ehealth.hubservices.core.v1.PutTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v1.PutTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.PutTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.RequestPublicationRequest;
import be.fgov.ehealth.hubservices.core.v1.RequestPublicationResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokeAccessRightRequest;
import be.fgov.ehealth.hubservices.core.v1.RevokeAccessRightResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokeHCPartyConsentRequest;
import be.fgov.ehealth.hubservices.core.v1.RevokeHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokePatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v1.RevokePatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokeTherapeuticLinkRequest;
import be.fgov.ehealth.hubservices.core.v1.RevokeTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokeTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.RevokeTransactionResponse;
import java.net.MalformedURLException;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntraHubServiceImpl
implements IntraHubService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final String SOAPACTION_DECLARE_TRANSACTION = "urn:be:fgov:ehealth:interhub:protocol:v1:DeclareTransaction";
    private static final String SOAPACTION_PUT_TRANSACTION = "urn:be:fgov:ehealth:interhub:protocol:v1:PutTransaction";
    private static final String SOAPACTION_REVOKE_TRANSACTION = "urn:be:fgov:ehealth:interhub:protocol:v1:RevokeTransaction";
    private static final String SOAPACTION_GET_TRANSACTIONLIST = "urn:be:fgov:ehealth:interhub:protocol:v1:GetTransactionList";
    private static final String SOAPACTION_GET_TRANSACTION = "urn:be:fgov:ehealth:interhub:protocol:v1:GetTransaction";
    private static final String SOAPACTION_REQUEST_PUBLICATION = "urn:be:fgov:ehealth:interhub:protocol:v1:RequestPublication";
    private static final String SOAPACTION_PUT_HCPARTY = "urn:be:fgov:ehealth:interhub:protocol:v1:PutHCParty";
    private static final String SOAPACTION_GET_HCPARTY = "urn:be:fgov:ehealth:interhub:protocol:v1:GetHCParty";
    private static final String SOAPACTION_PUT_PATIENT = "urn:be:fgov:ehealth:interhub:protocol:v1:PutPatient";
    private static final String SOAPACTION_GET_PATIENT = "urn:be:fgov:ehealth:interhub:protocol:v1:GetPatient";
    private static final String SOAPACTION_PUT_HCPARTYCONSENT = "urn:be:fgov:ehealth:interhub:protocol:v1:PutHCPartyConsent";
    private static final String SOAPACTION_GET_HCPARTYCONSENT = "urn:be:fgov:ehealth:interhub:protocol:v1:GetHCPartyConsent";
    private static final String SOAPACTION_REVOKE_HCPARTYCONSENT = "urn:be:fgov:ehealth:interhub:protocol:v1:RevokeHCPartyConsent";
    private static final String SOAPACTION_PUT_PATIENTCONSENT = "urn:be:fgov:ehealth:interhub:protocol:v1:PutPatientConsent";
    private static final String SOAPACTION_GET_PATIENTCONSENT = "urn:be:fgov:ehealth:interhub:protocol:v1:GetPatientConsent";
    private static final String SOAPACTION_REVOKE_PATIENTCONSENT = "urn:be:fgov:ehealth:interhub:protocol:v1:RevokePatientConsent";
    private static final String SOAPACTION_PUT_THERAPEUTICLINK = "urn:be:fgov:ehealth:interhub:protocol:v1:PutTherapeuticLink";
    private static final String SOAPACTION_GET_THERAPEUTICLINK = "urn:be:fgov:ehealth:interhub:protocol:v1:GetTherapeuticLink";
    private static final String SOAPACTION_REVOKE_THERAPEUTICLINK = "urn:be:fgov:ehealth:interhub:protocol:v1:RevokeTherapeuticLink";
    private static final String SOAPACTION_PUT_ACCESSRIGHT = "urn:be:fgov:ehealth:interhub:protocol:v1:PutAccessRight";
    private static final String SOAPACTION_GET_ACCESSRIGHT = "urn:be:fgov:ehealth:interhub:protocol:v1:GetAccessRight";
    private static final String SOAPACTION_REVOKE_ACCESSRIGHT = "urn:be:fgov:ehealth:interhub:protocol:v1:RevokeAccessRight";
    private static final String SOAPACTION_GET_PATIENTAUDIT = "urn:be:fgov:ehealth:interhub:protocol:v1:GetPatientAuditTrail";
    private static final Logger LOG = LoggerFactory.getLogger(IntraHubServiceImpl.class);
    private HubRequestHandler requestHandler = new HubRequestDoctor();

    @Override
    public DeclareTransactionResponse declareTransaction(SAMLToken token, DeclareTransactionRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        try {
            request.setRequest(this.requestHandler.handle());
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_DECLARE_TRANSACTION);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (DeclareTransactionResponse)genResp.asObject(DeclareTransactionResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutTransactionResponse putTransaction(SAMLToken token, PutTransactionRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        if (SessionUtil.getEncryptionCrypto() == null) {
            LOG.error("No Personal Crypto defined... Have you created a session that also loads your Personal eHealth Certificate?");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SECURITY_NO_CERTIFICATE, new Object[]{"Encryption for PutTransaction"});
        }
        HubRequestWithEncryption<PutTransactionRequest> encryptionHandler = new HubRequestWithEncryption<PutTransactionRequest>(this.requestHandler);
        request.setRequest(encryptionHandler.handle());
        PutTransactionRequest encryptedRequest = encryptionHandler.handleEncryption(request, SessionUtil.getEncryptionCrypto());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPortWithFolderEncryption(token, SOAPACTION_PUT_TRANSACTION);
            genReq.setPayload((Object)encryptedRequest);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutTransactionResponse)genResp.asObject(PutTransactionResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public RevokeTransactionResponse revokeTransaction(SAMLToken token, RevokeTransactionRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_REVOKE_TRANSACTION);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (RevokeTransactionResponse)genResp.asObject(RevokeTransactionResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetTransactionListResponse getTransactionList(SAMLToken token, GetTransactionListRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_TRANSACTIONLIST);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetTransactionListResponse)genResp.asObject(GetTransactionListResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetTransactionResponse getTransaction(SAMLToken token, GetTransactionRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        if (SessionUtil.getEncryptionCrypto() == null) {
            LOG.error("No Personal Crypto defined... Have you created a session that also loads your Personal eHealth Certificate?");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SECURITY_NO_CERTIFICATE, new Object[]{"Decryption for GetTransaction"});
        }
        LOG.debug("Wrapping the requestHandler (to fill in KMEHR header) with Encryption");
        HubRequestWithEncryption<GetTransactionRequest> encryptionHandler = new HubRequestWithEncryption<GetTransactionRequest>(this.requestHandler);
        request.setRequest(encryptionHandler.handle());
        GetTransactionRequest encryptedRequest = encryptionHandler.handleEncryption(request, SessionUtil.getEncryptionCrypto());
        LOG.debug("Sending message with KMEHR headers to hub");
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPortWithFolderEncryption(token, SOAPACTION_GET_TRANSACTION);
            genReq.setPayload((Object)encryptedRequest);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetTransactionResponse)genResp.asObject(GetTransactionResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public RequestPublicationResponse requestPublication(SAMLToken token, RequestPublicationRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_REQUEST_PUBLICATION);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (RequestPublicationResponse)genResp.asObject(RequestPublicationResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutHCPartyResponse putHCParty(SAMLToken token, PutHCPartyRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_PUT_HCPARTY);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutHCPartyResponse)genResp.asObject(PutHCPartyResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetHCPartyResponse getHCParty(SAMLToken token, GetHCPartyRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_HCPARTY);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetHCPartyResponse)genResp.asObject(GetHCPartyResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutPatientResponse putPatient(SAMLToken token, PutPatientRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_PUT_PATIENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutPatientResponse)genResp.asObject(PutPatientResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetPatientResponse getPatient(SAMLToken token, GetPatientRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_PATIENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetPatientResponse)genResp.asObject(GetPatientResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutHCPartyConsentResponse putHCPartyConsent(SAMLToken token, PutHCPartyConsentRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_PUT_HCPARTYCONSENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutHCPartyConsentResponse)genResp.asObject(PutHCPartyConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetHCPartyConsentResponse getHCPartyConsent(SAMLToken token, GetHCPartyConsentRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_HCPARTYCONSENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetHCPartyConsentResponse)genResp.asObject(GetHCPartyConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public RevokeHCPartyConsentResponse revokeHCPartyConsent(SAMLToken token, RevokeHCPartyConsentRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_REVOKE_HCPARTYCONSENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (RevokeHCPartyConsentResponse)genResp.asObject(RevokeHCPartyConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutPatientConsentResponse putPatientConsent(SAMLToken token, PutPatientConsentRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_PUT_PATIENTCONSENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutPatientConsentResponse)genResp.asObject(PutPatientConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetPatientConsentResponse getPatientConsent(SAMLToken token, GetPatientConsentRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_PATIENTCONSENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetPatientConsentResponse)genResp.asObject(GetPatientConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public RevokePatientConsentResponse revokePatientConsent(SAMLToken token, RevokePatientConsentRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_REVOKE_PATIENTCONSENT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (RevokePatientConsentResponse)genResp.asObject(RevokePatientConsentResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutTherapeuticLinkResponse putTherapeuticLink(SAMLToken token, PutTherapeuticLinkRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_PUT_THERAPEUTICLINK);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutTherapeuticLinkResponse)genResp.asObject(PutTherapeuticLinkResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetTherapeuticLinkResponse getTherapeuticLink(SAMLToken token, GetTherapeuticLinkRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_THERAPEUTICLINK);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetTherapeuticLinkResponse)genResp.asObject(GetTherapeuticLinkResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public RevokeTherapeuticLinkResponse revokeTherapeuticLink(SAMLToken token, RevokeTherapeuticLinkRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_REVOKE_THERAPEUTICLINK);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (RevokeTherapeuticLinkResponse)genResp.asObject(RevokeTherapeuticLinkResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public PutAccessRightResponse putAccessRight(SAMLToken token, PutAccessRightRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_PUT_ACCESSRIGHT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (PutAccessRightResponse)genResp.asObject(PutAccessRightResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetAccessRightResponse getAccessRight(SAMLToken token, GetAccessRightRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_ACCESSRIGHT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetAccessRightResponse)genResp.asObject(GetAccessRightResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public RevokeAccessRightResponse revokeAccessRight(SAMLToken token, RevokeAccessRightRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_REVOKE_ACCESSRIGHT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (RevokeAccessRightResponse)genResp.asObject(RevokeAccessRightResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public GetPatientAuditTrailResponse getPatientAuditTrail(SAMLToken token, GetPatientAuditTrailRequest request) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        request.setRequest(this.requestHandler.handle());
        try {
            GenericRequest genReq = ServiceFactory.getIntraHubPort(token, SOAPACTION_GET_PATIENTAUDIT);
            genReq.setPayload((Object)request);
            GenericResponse genResp = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(genReq);
            return (GetPatientAuditTrailResponse)genResp.asObject(GetPatientAuditTrailResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw this.handleWebServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private TechnicalConnectorException handleWebServiceException(WebServiceException e) {
        if (e.getCause() instanceof FolderDecryptionRuntimeException) {
            FolderDecryptionRuntimeException decryptException = (FolderDecryptionRuntimeException)e.getCause();
            if (decryptException.getCause() instanceof TechnicalConnectorException) {
                return (TechnicalConnectorException)decryptException.getCause();
            }
            return new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNKNOWN_ERROR, (Throwable)e, new Object[]{""});
        }
        return new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNKNOWN_ERROR, e.getCause(), new Object[]{e.getMessage()});
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeclareTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeclareTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAccessRightRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAccessRightResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientAuditTrailRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientAuditTrailResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTherapeuticLinkRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTherapeuticLinkResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionListResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutAccessRightRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutAccessRightResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTherapeuticLinkRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTherapeuticLinkResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestPublicationRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestPublicationResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeAccessRightRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeAccessRightResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeHCPartyConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeHCPartyConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokePatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokePatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTherapeuticLinkRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTherapeuticLinkResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTransactionResponse.class});
    }
}

