/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hub.security;

import be.ehealth.business.kmehrcommons.builders.Cd;
import be.ehealth.business.kmehrcommons.builders.Id;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.hub.security.FolderEncryptor;
import be.ehealth.businessconnector.hub.security.HubRequestHandler;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.hubservices.core.v1.RequestType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDENCRYPTIONACTORvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYvalues;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class HubRequestWithEncryption<X>
implements HubRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HubRequestWithEncryption.class);
    private static final String USER_PROFESSION = "user.kmerhprofession";
    private static Configuration config = ConfigFactory.getConfigValidator();
    private HubRequestHandler baseHandler;

    public HubRequestWithEncryption(HubRequestHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public X handleEncryption(X request, Crypto crypto) throws IntraHubBusinessConnectorException, TechnicalConnectorException {
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{request.getClass()}).createMarshaller();
            DOMResult res = new DOMResult();
            marshaller.marshal(request, (Result)res);
            Document doc = FolderEncryptor.encryptFolder((Document)res.getNode(), crypto);
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{request.getClass()}).createUnmarshaller();
            return (X)unmarshaller.unmarshal(doc.getFirstChild());
        }
        catch (JAXBException e) {
            LOG.error("JAXBException when (un)marchalling the request", (Throwable)e);
            return request;
        }
    }

    @Override
    public RequestType handle() throws IntraHubBusinessConnectorException {
        RequestType baseInfo = this.baseHandler.handle();
        String profession = config.getProperty(USER_PROFESSION, CDHCPARTYvalues.PERSPHYSICIAN.toString());
        boolean found = false;
        for (HcpartyType party : baseInfo.getAuthor().getHcparties()) {
            for (CDHCPARTY partyType : party.getCds()) {
                partyType.getValue().equalsIgnoreCase(profession);
                found = true;
            }
            if (!found) continue;
            this.addEncryptionActor(party);
        }
        HcpartyType encryptionApplication = this.addEncryptionApplication("");
        baseInfo.getAuthor().getHcparties().add(encryptionApplication);
        return baseInfo;
    }

    private void addEncryptionActor(HcpartyType hcParty) throws IntraHubBusinessConnectorException {
        Id idBuilder = new Id().s(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR).sv("1.0");
        Cd cdBuilder = new Cd().s(CDHCPARTYschemes.CD_ENCRYPTION_ACTOR).sv("1.0");
        if (this.getNihii() == null) {
            idBuilder.value(this.getNiss());
            cdBuilder.value(CDENCRYPTIONACTORvalues.INSS.toString());
        } else {
            idBuilder.value(this.getNihii());
            cdBuilder.value(CDENCRYPTIONACTORvalues.NIHII.toString());
        }
        hcParty.getIds().add(idBuilder.build());
        hcParty.getCds().add(cdBuilder.build());
    }

    private String getNiss() throws IntraHubBusinessConnectorException {
        try {
            return SessionUtil.getNiss();
        }
        catch (TechnicalConnectorException e) {
            LOG.warn(e.getMessage());
            throw new IntraHubBusinessConnectorException(IntraHubBusinessConnectorExceptionValues.ERROR, e, e.getMessage());
        }
    }

    private String getNihii() {
        try {
            return SessionUtil.getNihii();
        }
        catch (TechnicalConnectorException e) {
            LOG.debug("Unable to obtain nihii. Reason: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private HcpartyType addEncryptionApplication(String applicationName) {
        HcpartyType hcParty = new HcpartyType();
        hcParty.getIds().add(new Id().s(IDHCPARTYschemes.ID_ENCRYPTION_APPLICATION).sv("1.0").value(applicationName).build());
        hcParty.getCds().add(new Cd().s(CDHCPARTYschemes.CD_APPLICATION).sv("1.1").value(CDHCPARTYvalues.APPLICATION.toString()).build());
        return hcParty;
    }
}

