/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hub.security;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class FolderDecryptor {
    private static final Logger LOG = LoggerFactory.getLogger(FolderDecryptor.class);
    protected static final String KMEHR_NAMESPACE = "http://www.ehealth.fgov.be/standards/kmehr/schema/v1";
    private static final byte[] KMEHRMESSAGE_START_NODE = "<kmehrmessage xmlns=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\" >".getBytes();
    private static final byte[] KMEHRMESSAGE_END_NODE = "</kmehrmessage>".getBytes();
    private static final String FOLDER = "folder";
    private static final String BASE64_ENCRYPTED_DATA = "Base64EncryptedData";
    private static final String BASE64_ENCRYPTED_VALUE = "Base64EncryptedValue";
    private static DocumentBuilder builder;

    private FolderDecryptor() {
    }

    public static void decryptFolder(SOAPBody soapBody, Crypto crypto) throws TechnicalConnectorException {
        Node base64EncryptedDataNode = null;
        Node base64EncryptedDataParentNode = null;
        NodeList folderNodes = soapBody.getElementsByTagNameNS(KMEHR_NAMESPACE, BASE64_ENCRYPTED_DATA);
        if (folderNodes.getLength() == 1) {
            base64EncryptedDataNode = folderNodes.item(0);
            base64EncryptedDataParentNode = base64EncryptedDataNode.getParentNode();
            try {
                NodeList encryptedContent = ((Element)base64EncryptedDataNode).getElementsByTagNameNS(KMEHR_NAMESPACE, BASE64_ENCRYPTED_VALUE);
                if (encryptedContent.getLength() == 0 || encryptedContent.getLength() > 1) {
                    LOG.debug("Base64EncryptedValue is not a valid content. Nothing to decrypt.");
                    return;
                }
                String encryptedData = encryptedContent.item(0).getTextContent();
                byte[] b64decryptedData = Base64.decode((byte[])encryptedData.getBytes());
                byte[] decryptedMessage = crypto.unseal(b64decryptedData);
                base64EncryptedDataParentNode.removeChild(base64EncryptedDataNode);
                NodeList folders = FolderDecryptor.getFolders(decryptedMessage);
                for (int i = 0; i < folders.getLength(); ++i) {
                    Element folderElement = (Element)folders.item(i);
                    Node folder = base64EncryptedDataParentNode.getOwnerDocument().importNode(folderElement, true);
                    base64EncryptedDataParentNode.appendChild(folder);
                }
            }
            catch (SAXException e) {
                LOG.error("SAXException when decrypting the SOAP folder", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("IOException when decrypting the SOAP folder", (Throwable)e);
            }
        } else if (folderNodes.getLength() == 0) {
            LOG.debug("No node with name Base64EncryptedDatafound to decrypt");
        } else if (folderNodes.getLength() > 1) {
            LOG.debug("More then one node with name Base64EncryptedDatafound to decrypt");
        }
    }

    private static NodeList getFolders(byte[] decryptedMessage) throws SAXException, IOException {
        byte[] kmerh = ArrayUtils.addAll(null, (byte[])KMEHRMESSAGE_START_NODE);
        kmerh = ArrayUtils.addAll((byte[])kmerh, (byte[])decryptedMessage);
        kmerh = ArrayUtils.addAll((byte[])kmerh, (byte[])KMEHRMESSAGE_END_NODE);
        Document doc = builder.parse(new InputSource(new ByteArrayInputStream(kmerh)));
        return doc.getElementsByTagNameNS(KMEHR_NAMESPACE, FOLDER);
    }

    static {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to instaniate a Documentbuilder", e);
        }
    }
}

