/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.insurabilityv2.service;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_INSURABILITY_V2 = "endpoint.insurabilityv2";
    private static final String PROP_VALIDATION_INCOMING_INSURABILITY = "validation.incoming.message.insurability.v2";
    private static final String INSURABILITY_PROT = "/XSD/ehealth-insurability/XSD/insurabilityservices_protocol-2_0.xsd";
    private static Configuration config = ConfigFactory.getConfigValidatorFor((String[])new String[]{"endpoint.insurabilityv2"});
    static final String[] INSURABILITY_XSD = new String[]{"/XSD/ehealth-insurability/XSD/insurabilityservices_protocol-2_0.xsd"};

    private ServiceFactory() {
    }

    public static GenericRequest getService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_INSURABILITY_V2));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_INSURABILITY))) {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, INSURABILITY_XSD));
        } else {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, INSURABILITY_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }
}

