/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.builders.impl;

import be.ehealth.businessconnector.ehbox.v3.builders.RequestBuilder;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteOoORequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetAllEhboxesMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetBoxInfoRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetHistoryRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessageAcknowledgmentsStatusRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetOoOListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.InsertOoORequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.MessageRequestType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.MoveMessageRequest;
import be.fgov.ehealth.ehbox.core.v3.BoxIdType;
import java.util.List;
import org.joda.time.DateTime;

public class RequestBuilderImpl
implements RequestBuilder {
    private static String[] stringTemplate = new String[0];
    private static BoxIdType[] boxIdTemplate = new BoxIdType[0];

    @Override
    public DeleteMessageRequest createDeleteMessageRequest(String source, String ... messageIds) {
        return this.createDeleteMessageRequest(source, (BoxIdType)null, messageIds);
    }

    @Override
    public GetAllEhboxesMessagesListRequest createGetAllEhboxesMessagesListRequest(String source, Integer startIndex, Integer endIndex) {
        GetAllEhboxesMessagesListRequest request = new GetAllEhboxesMessagesListRequest();
        request.setSource(source);
        request.setStartIndex(startIndex);
        request.setEndIndex(endIndex);
        return request;
    }

    @Override
    public GetMessagesListRequest createGetMessagesListRequest(String source, int startIndex, int endIndex, BoxIdType boxId) {
        GetMessagesListRequest request = new GetMessagesListRequest();
        request.setSource(source);
        request.setStartIndex(Integer.valueOf(startIndex));
        request.setEndIndex(Integer.valueOf(endIndex));
        request.setBoxId(boxId);
        return request;
    }

    @Override
    public GetMessagesListRequest createGetMessagesListRequest(String source) {
        GetMessagesListRequest request = new GetMessagesListRequest();
        request.setSource(source);
        return request;
    }

    @Override
    public DeleteMessageRequest createDeleteMessageRequest(String source, BoxIdType boxId, String ... messageIds) {
        DeleteMessageRequest deleteMessageRequest = new DeleteMessageRequest();
        deleteMessageRequest.setBoxId(boxId);
        deleteMessageRequest.setSource(source);
        for (String messageId : messageIds) {
            deleteMessageRequest.getMessageIds().add(messageId);
        }
        return deleteMessageRequest;
    }

    @Override
    public GetBoxInfoRequest createBoxInfoRequestForDefaultBox() {
        return new GetBoxInfoRequest();
    }

    @Override
    public GetBoxInfoRequest createBoxInfoRequest(BoxIdType boxId) {
        GetBoxInfoRequest getBoxInfoRequest = new GetBoxInfoRequest();
        getBoxInfoRequest.setBoxId(boxId);
        return getBoxInfoRequest;
    }

    @Override
    public GetAllEhboxesMessagesListRequest createAllEhboxesMessagesListRequest(String source) {
        return this.createAllEhboxesMessagesListRequest(source, null, null);
    }

    @Override
    public GetAllEhboxesMessagesListRequest createAllEhboxesMessagesListRequest(String source, Integer startIndex, Integer endIndex) {
        GetAllEhboxesMessagesListRequest getAllEhboxesMessagesListRequest = new GetAllEhboxesMessagesListRequest();
        getAllEhboxesMessagesListRequest.setStartIndex(startIndex);
        getAllEhboxesMessagesListRequest.setEndIndex(endIndex);
        getAllEhboxesMessagesListRequest.setSource(source);
        return getAllEhboxesMessagesListRequest;
    }

    @Override
    public MessageRequestType createMessageRequestType(String messageId) {
        return this.createMessageRequestType(messageId, "INBOX");
    }

    @Override
    public MessageRequestType createMessageRequestType(String messageId, String source) {
        return this.createMessageRequestType(messageId, source, null);
    }

    @Override
    public MessageRequestType createMessageRequestType(String messageId, String source, BoxIdType boxId) {
        MessageRequestType messageRequestType = new MessageRequestType();
        messageRequestType.setBoxId(boxId);
        messageRequestType.setMessageId(messageId);
        messageRequestType.setSource(source);
        return messageRequestType;
    }

    @Override
    public GetFullMessageRequest createGetFullMessageRequest(String messageId) {
        return this.createGetFullMessageRequest(messageId, "INBOX");
    }

    @Override
    public GetFullMessageRequest createGetFullMessageRequest(String messageId, String source) {
        return this.createGetFullMessageRequest(messageId, source, null);
    }

    @Override
    public GetFullMessageRequest createGetFullMessageRequest(String messageId, String source, BoxIdType boxId) {
        GetFullMessageRequest messageRequestType = new GetFullMessageRequest();
        messageRequestType.setBoxId(boxId);
        messageRequestType.setMessageId(messageId);
        messageRequestType.setSource(source);
        return messageRequestType;
    }

    @Override
    public GetHistoryRequest createGetHistoryRequest(String messageId) {
        return this.createGetHistoryRequest(messageId, null);
    }

    @Override
    public GetHistoryRequest createGetHistoryRequest(String messageId, String source) {
        return this.createGetHistoryRequest(messageId, source, null);
    }

    @Override
    public GetHistoryRequest createGetHistoryRequest(String messageId, String source, BoxIdType boxId) {
        GetHistoryRequest messageRequestType = new GetHistoryRequest();
        messageRequestType.setBoxId(boxId);
        messageRequestType.setMessageId(messageId);
        messageRequestType.setSource(source);
        return messageRequestType;
    }

    @Override
    public MoveMessageRequest createMoveMessageRequest(String source, String destination, String ... messageIds) {
        return this.createMoveMessageRequest(source, destination, (BoxIdType)null, messageIds);
    }

    @Override
    public MoveMessageRequest createMoveMessageRequest(String source, String destination, BoxIdType boxId, String ... messageIds) {
        MoveMessageRequest moveMessageRequest = new MoveMessageRequest();
        moveMessageRequest.setBoxId(boxId);
        moveMessageRequest.setDestination(destination);
        moveMessageRequest.setSource(source);
        for (String messageId : messageIds) {
            moveMessageRequest.getMessageIds().add(messageId);
        }
        return moveMessageRequest;
    }

    @Override
    public GetMessageAcknowledgmentsStatusRequest createGetMessageAcknowledgmentsStatusRequest(String messageId) {
        return this.createGetMessageAcknowledgmentsStatusRequest(messageId, null, null, null);
    }

    @Override
    public GetMessageAcknowledgmentsStatusRequest createGetMessageAcknowledgmentsStatusRequest(String messageId, Integer startIndex, Integer endIndex, BoxIdType boxId) {
        GetMessageAcknowledgmentsStatusRequest getMessageAcknowledgmentsStatusRequest = new GetMessageAcknowledgmentsStatusRequest();
        getMessageAcknowledgmentsStatusRequest.setBoxId(boxId);
        getMessageAcknowledgmentsStatusRequest.setEndIndex(endIndex);
        getMessageAcknowledgmentsStatusRequest.setMessageId(messageId);
        getMessageAcknowledgmentsStatusRequest.setStartIndex(startIndex);
        return getMessageAcknowledgmentsStatusRequest;
    }

    @Override
    public DeleteOoORequest createDeleteOoORequest(String ... oOoIds) {
        return this.createDeleteOoORequest((BoxIdType)null, oOoIds);
    }

    @Override
    public DeleteOoORequest createDeleteOoORequest(List<String> oOoIds) {
        return this.createDeleteOoORequest(oOoIds.toArray(stringTemplate));
    }

    @Override
    public DeleteOoORequest createDeleteOoORequest(BoxIdType boxId, String ... oOoIds) {
        DeleteOoORequest deleteOoORequest = new DeleteOoORequest();
        deleteOoORequest.setBoxId(boxId);
        for (String oOoId : oOoIds) {
            deleteOoORequest.getOoOIds().add(oOoId);
        }
        return deleteOoORequest;
    }

    @Override
    public DeleteOoORequest createDeleteOoORequest(BoxIdType boxId, List<String> oOoIds) {
        return this.createDeleteOoORequest(boxId, oOoIds.toArray(stringTemplate));
    }

    @Override
    public GetOoOListRequest createGetOoOListRequest() {
        return this.createGetOoOListRequest(null);
    }

    @Override
    public GetOoOListRequest createGetOoOListRequest(BoxIdType boxId) {
        GetOoOListRequest getOoOListRequest = new GetOoOListRequest();
        getOoOListRequest.setBoxId(boxId);
        return getOoOListRequest;
    }

    @Override
    public InsertOoORequest createInsertOoORequest(DateTime startDate, DateTime endDate, BoxIdType ... substitutes) {
        return this.createInsertOoORequest(null, startDate, endDate, substitutes);
    }

    @Override
    public InsertOoORequest createInsertOoORequest(BoxIdType boxId, DateTime startDate, DateTime endDate, BoxIdType ... substitutes) {
        InsertOoORequest insertOoORequest = new InsertOoORequest();
        insertOoORequest.setBoxId(boxId);
        insertOoORequest.setStartDate(startDate);
        insertOoORequest.setEndDate(endDate);
        for (BoxIdType subtitute : substitutes) {
            insertOoORequest.getSubstitutes().add(subtitute);
        }
        return insertOoORequest;
    }

    @Override
    public DeleteMessageRequest createDeleteMessageRequest(String source, List<String> messageIds) {
        return this.createDeleteMessageRequest(source, messageIds.toArray(stringTemplate));
    }

    @Override
    public DeleteMessageRequest createDeleteMessageRequest(String source, BoxIdType boxId, List<String> messageIds) {
        return this.createDeleteMessageRequest(source, boxId, messageIds.toArray(stringTemplate));
    }

    @Override
    public MoveMessageRequest createMoveMessageRequest(String source, String destination, List<String> messageIds) {
        return this.createMoveMessageRequest(source, destination, messageIds.toArray(stringTemplate));
    }

    @Override
    public MoveMessageRequest createMoveMessageRequest(String source, String destination, BoxIdType boxId, List<String> messageIds) {
        return this.createMoveMessageRequest(source, destination, boxId, messageIds.toArray(stringTemplate));
    }

    @Override
    public InsertOoORequest createInsertOoORequest(DateTime startDate, DateTime endDate, List<BoxIdType> substitutes) {
        return this.createInsertOoORequest(startDate, endDate, substitutes.toArray(boxIdTemplate));
    }

    @Override
    public InsertOoORequest createInsertOoORequest(BoxIdType boxId, DateTime startDate, DateTime endDate, List<BoxIdType> substitutes) {
        return this.createInsertOoORequest(boxId, startDate, endDate, substitutes.toArray(boxIdTemplate));
    }
}

