/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.service.impl;

import be.ehealth.businessconnector.ehbox.v3.service.ConsultationService;
import be.ehealth.businessconnector.ehbox.v3.service.ServiceFactory;
import be.ehealth.businessconnector.ehbox.v3.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteOoORequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteOoOResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetAllEhboxesMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetAllEhboxesMessagesListResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetBoxInfoRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetBoxInfoResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetHistoryRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetHistoryResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessageAcknowledgmentsStatusRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessageAcknowledgmentsStatusResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessagesListResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetOoOListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetOoOListResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.InsertOoORequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.InsertOoOResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.MessageRequestType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.MoveMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.MoveMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultationServiceImpl
implements ConsultationService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(ConsultationServiceImpl.class);
    private EhboxReplyValidator replyValidator;
    private SessionValidator sessionValidator;

    public ConsultationServiceImpl(SessionValidator sessionValidator, EhboxReplyValidator replyValidator) {
        this.replyValidator = replyValidator;
        this.sessionValidator = sessionValidator;
    }

    public ConsultationServiceImpl() {
        LOG.debug("creating ConsultationServiceImpl for bootstrapping purposes");
    }

    private <T extends ResponseType> T callService(SAMLToken token, Object request, String soapAction, Class<T> clazz) throws ConnectorException {
        try {
            this.sessionValidator.validateToken(token);
            GenericRequest service = ServiceFactory.getConsultationService(token);
            service.setPayload(request);
            service.setSoapAction(soapAction);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            ResponseType response = (ResponseType)xmlResponse.asObject(clazz);
            this.replyValidator.validateReplyStatus(response);
            return (T)response;
        }
        catch (Exception e) {
            if (e instanceof TechnicalConnectorException) {
                throw (TechnicalConnectorException)e;
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public final GetBoxInfoResponse getBoxInfo(SAMLToken token, GetBoxInfoRequest getBoxInfoRequest) throws ConnectorException {
        return this.callService(token, getBoxInfoRequest, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getBoxInfo", GetBoxInfoResponse.class);
    }

    @Override
    public GetFullMessageResponse getFullMessage(SAMLToken token, GetFullMessageRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getFullMessage", GetFullMessageResponse.class);
    }

    @Override
    @Deprecated
    public GetFullMessageResponse getFullMessage(SAMLToken token, MessageRequestType request) throws ConnectorException {
        GetFullMessageRequest requestToUse = this.mapToCorrectType(request, new GetFullMessageRequest());
        return this.callService(token, requestToUse, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getFullMessage", GetFullMessageResponse.class);
    }

    @Override
    @Deprecated
    public final GetHistoryResponse getMessageHistory(SAMLToken token, MessageRequestType request) throws ConnectorException {
        GetHistoryRequest requestToUse = this.mapToCorrectType(request, new GetHistoryRequest());
        return this.callService(token, requestToUse, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getMessageHistory", GetHistoryResponse.class);
    }

    private <T extends MessageRequestType> T mapToCorrectType(MessageRequestType originalRequest, T newInstanceOfCorrectType) {
        newInstanceOfCorrectType.setBoxId(originalRequest.getBoxId());
        newInstanceOfCorrectType.setMessageId(originalRequest.getMessageId());
        newInstanceOfCorrectType.setSource(originalRequest.getSource());
        return newInstanceOfCorrectType;
    }

    @Override
    public GetHistoryResponse getMessageHistory(SAMLToken token, GetHistoryRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getMessageHistory", GetHistoryResponse.class);
    }

    @Override
    public final GetMessagesListResponse getMessageList(SAMLToken token, GetMessagesListRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getMessagesList", GetMessagesListResponse.class);
    }

    @Override
    public final GetMessageAcknowledgmentsStatusResponse getMessageAcknowledgmentsStatusResponse(SAMLToken token, GetMessageAcknowledgmentsStatusRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getMessageAcknowledgmentsStatus", GetMessageAcknowledgmentsStatusResponse.class);
    }

    @Override
    public final DeleteMessageResponse deleteMessage(SAMLToken token, DeleteMessageRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:deleteMessage", DeleteMessageResponse.class);
    }

    @Override
    public final MoveMessageResponse moveMessage(SAMLToken token, MoveMessageRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:moveMessage", MoveMessageResponse.class);
    }

    @Override
    public InsertOoOResponse insertOoO(SAMLToken token, InsertOoORequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:insertOoO", InsertOoOResponse.class);
    }

    @Override
    public final DeleteOoOResponse deleteOoO(SAMLToken token, DeleteOoORequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:deleteOoO", DeleteOoOResponse.class);
    }

    @Override
    public final GetOoOListResponse getOoOList(SAMLToken token, GetOoOListRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getOoOList", GetOoOListResponse.class);
    }

    @Override
    public GetAllEhboxesMessagesListResponse getAllEhboxesMessagesList(SAMLToken token, GetAllEhboxesMessagesListRequest request) throws ConnectorException {
        return this.callService(token, request, "urn:be:fgov:ehealth:ehbox:consultation:protocol:v3:getAllEhboxesMessagesList", GetAllEhboxesMessagesListResponse.class);
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeleteMessageRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeleteMessageResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeleteOoORequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeleteOoOResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAllEhboxesMessagesListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAllEhboxesMessagesListResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetBoxInfoRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetBoxInfoResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetFullMessageRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetFullMessageResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHistoryRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHistoryResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessageAcknowledgmentsStatusRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessageAcknowledgmentsStatusResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessagesListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessagesListResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetOoOListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetOoOListResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{InsertOoORequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{InsertOoOResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{MessageRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{MoveMessageRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{MoveMessageResponse.class});
    }
}

