/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.builders.impl;

import be.ehealth.businessconnector.ehbox.api.domain.AcknowledgeMessage;
import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.domain.ErrorMessage;
import be.ehealth.businessconnector.ehbox.api.domain.Message;
import be.ehealth.businessconnector.ehbox.api.domain.NewsMessage;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.ehbox.v3.exception.EhboxCryptoException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.UnsealConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.utils.ConnectorExceptionUtils;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.ehbox.core.v3.ContentInfoType;
import be.fgov.ehealth.ehbox.core.v3.ContentSpecificationType;
import be.fgov.ehealth.ehbox.core.v3.CustomMetaType;
import be.fgov.ehealth.ehbox.core.v3.EhboxIdentifierType;
import be.fgov.ehealth.ehbox.core.v3.MessageInfoType;
import be.fgov.ehealth.ehbox.core.v3.SenderType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsultationBuilder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConsultationBuilder.class);

    @Deprecated
    public AbstractConsultationBuilder(Crypto crypto) {
        this();
    }

    public AbstractConsultationBuilder() {
    }

    protected void processCustomMetas(List<CustomMetaType> metas, Message<T> message) {
        if (metas != null) {
            for (CustomMetaType meta : metas) {
                message.getCustomMetas().put(meta.getKey(), meta.getValue());
            }
        }
    }

    protected void processSender(SenderType inSender, ContentSpecificationType contentspec, Message<T> message) {
        if (inSender != null) {
            Addressee addressee = this.buildAddressee(inSender);
            if (contentspec != null) {
                addressee.setApplicationId(contentspec.getApplicationName());
            }
            message.setSender(addressee);
        }
    }

    protected void processContentInfo(ContentInfoType contentInfo, Message<T> message) {
        if (contentInfo != null) {
            message.setHasAnnex(contentInfo.isHasAnnex());
            message.setHasFreeInformations(contentInfo.isHasFreeInformations());
        }
    }

    protected final Addressee buildAddressee(SenderType sender) {
        IdentifierType identifierType = IdentifierType.lookup((String)sender.getType(), (String)sender.getSubType(), (int)49);
        Addressee destination = new Addressee(identifierType);
        destination.setId(sender.getId());
        if (StringUtils.isEmpty((String)sender.getPersonInOrganisation())) {
            destination.setFirstName(sender.getFirstName());
            destination.setLastName(sender.getName());
        } else {
            destination.setOrganizationName(sender.getName());
            destination.setPersonInOrganisation(sender.getPersonInOrganisation());
        }
        destination.setQuality(sender.getQuality());
        return destination;
    }

    protected final Addressee buildAddressee(EhboxIdentifierType identifier) {
        IdentifierType identifierType = IdentifierType.lookup((String)identifier.getType(), (String)identifier.getSubType(), (int)49);
        Addressee destination = new Addressee(identifierType);
        destination.setId(identifier.getId());
        if (identifier.getUser() != null) {
            destination.setFirstName(identifier.getUser().getFirstName());
            destination.setLastName(identifier.getUser().getLastName());
        }
        destination.setQuality(identifier.getQuality());
        return destination;
    }

    protected void processMessageInfo(MessageInfoType response, Message<T> message) {
        if (response != null) {
            message.setExpirationDateTime(response.getExpirationDate());
            message.setPublicationDateTime(response.getPublicationDate());
            message.setSize(response.getSize());
        }
    }

    protected void processContentSpecification(ContentSpecificationType contentspec, Message<T> message) {
        if (contentspec != null) {
            message.setImportant(contentspec.isIsImportant());
            message.setEncrypted(contentspec.isIsEncrypted());
            if (message.getSender() != null) {
                message.getSender().setApplicationId(contentspec.getApplicationName());
            }
        }
    }

    protected final byte[] handleAndDecryptIfNeeded(byte[] data, boolean encrypted, ExceptionContainer<?> container) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        if (ArrayUtils.isEmpty((byte[])data)) {
            return data;
        }
        byte[] byteVal = ArrayUtils.clone((byte[])data);
        if (ConfigFactory.getConfigValidator().getBooleanProperty("ehboxv3.try.to.base64decode.content", Boolean.valueOf(true)).booleanValue()) {
            byteVal = ConnectorIOUtils.base64Decode((byte[])byteVal, (boolean)false);
        }
        if (encrypted) {
            if (SessionUtil.getEncryptionCrypto() == null) {
                throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.CRYPTO_NOT_PROPERLY_INITIALIZED, (Throwable)null, new Object[0]);
            }
            try {
                byteVal = SessionUtil.getEncryptionCrypto().unseal(Crypto.SigningPolicySelector.WITH_NON_REPUDIATION, byteVal).getContentAsByte();
            }
            catch (UnsealConnectorException e) {
                ((ExceptionContainer)container).exceptions.add(e);
                try {
                    byteVal = ConnectorExceptionUtils.processUnsealConnectorException((UnsealConnectorException)e, (String[])new String[0]);
                }
                catch (UnsealConnectorException unrecoverableUnsealException) {
                    ArrayList<UnsealConnectorException> unsealExceptions = new ArrayList<UnsealConnectorException>();
                    unsealExceptions.add(unrecoverableUnsealException);
                    LOG.error("unrecoverable unsealException occurred while decrypting ehbox content , returning null as message , error : " + unrecoverableUnsealException.getMessage());
                    throw new EhboxCryptoException(unsealExceptions, null);
                }
            }
        }
        return byteVal;
    }

    protected Message<T> createMessage(ContentSpecificationType content, T responseMsg, String id, String publicationId) throws EhboxBusinessConnectorException {
        DocumentMessage message = null;
        if ("DOCUMENT".equals(content.getContentType())) {
            message = new DocumentMessage();
        } else if ("NEWS".equals(content.getContentType())) {
            message = new NewsMessage();
        } else if ("ERROR".equals(content.getContentType())) {
            message = new ErrorMessage();
        } else if ("ACKNOWLEDGMENT".equals(content.getContentType())) {
            message = new AcknowledgeMessage();
        } else {
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, new Object[]{"Unsupported contentType", content.getContentType()});
        }
        message.setOriginal(responseMsg);
        message.setId(id);
        message.setPublicationId(publicationId);
        return message;
    }

    static class ExceptionContainer<T> {
        private Message<T> message;
        private List<UnsealConnectorException> exceptions = new ArrayList<UnsealConnectorException>();

        public ExceptionContainer(Message<T> message) {
            this.message = message;
        }

        public Message<T> getMessage() throws EhboxCryptoException {
            if (this.exceptions.isEmpty()) {
                return this.message;
            }
            throw new EhboxCryptoException(this.exceptions, this.message);
        }
    }
}

