/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.validator.impl;

import be.ehealth.businessconnector.ehboxV2.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.fgov.ehealth.commons.core.v1.LocalisedString;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhboxReplyValidatorImpl
implements EhboxReplyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(EhboxReplyValidatorImpl.class);
    public static final String EHEALTH_SUCCESS_CODE_100 = "100";
    public static final String EHEALTH_SUCCESS_CODE_200 = "200";

    @Override
    public boolean validateReplyStatus(ResponseType response) throws TechnicalConnectorException {
        if (!EHEALTH_SUCCESS_CODE_100.equals(response.getStatus().getCode()) && !EHEALTH_SUCCESS_CODE_200.equals(response.getStatus().getCode())) {
            LOG.error("Error Status received : " + response.getStatus().getCode());
            String param = "Received error: " + response.getStatus().getCode() + " " + ((LocalisedString)response.getStatus().getMessages().get(0)).getValue();
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{param});
        }
        return true;
    }
}

