/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.service.impl;

import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.ehboxV2.service.ConsultationService;
import be.ehealth.businessconnector.ehboxV2.service.ServiceFactory;
import be.ehealth.businessconnector.ehboxV2.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.BusinessError;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.DeleteMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.DeleteMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.EhBoxConsultationPortType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetBoxInfoRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetBoxInfoResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetFullMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetHistoryResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageAcknowledgmentsStatusRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageAcknowledgmentsStatusResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageListResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.MessageRequestType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.MoveMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.SystemError;
import be.fgov.ehealth.errors.core.v1.LocalisedStringType;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultationServiceImpl
implements ConsultationService {
    private static final Logger LOG = LoggerFactory.getLogger(ConsultationServiceImpl.class);
    private static final String BEGINNINGTAB = "\t## ";
    private EhboxReplyValidator replyValidator;
    private SessionValidator sessionValidator;

    public ConsultationServiceImpl(SessionValidator sessionValidator, EhboxReplyValidator replyValidator) {
        this.replyValidator = replyValidator;
        this.sessionValidator = sessionValidator;
    }

    public ConsultationServiceImpl() {
        LOG.debug("creating ConsultationServiceImpl for bootstrap purposes");
    }

    private EhBoxConsultationPortType getConsultationService(SAMLToken token) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        try {
            this.sessionValidator.validateSession();
            return ServiceFactory.getConsultationService(token);
        }
        catch (MalformedURLException e) {
            LOG.debug("\t## Invalid URL : " + token + " : throwing technical connector exception");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, new Object[]{token});
        }
    }

    @Override
    public GetBoxInfoResponse getBoxInfo(SAMLToken token, GetBoxInfoRequest getBoxInfoRequest) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        GetBoxInfoResponse response;
        try {
            response = this.getConsultationService(token).getBoxInfo(getBoxInfoRequest);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }

    @Override
    public GetFullMessageResponse getFullMessage(SAMLToken token, MessageRequestType messageRequestType) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        GetFullMessageResponse response;
        try {
            response = this.getConsultationService(token).getFullMessage(messageRequestType);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }

    @Override
    public GetHistoryResponse getMessageHistory(SAMLToken token, MessageRequestType messageRequestType) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        GetHistoryResponse response;
        try {
            response = this.getConsultationService(token).getMessageHistory(messageRequestType);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }

    @Override
    public GetMessageListResponseType getMessageList(SAMLToken token, GetMessagesListRequest messagesListRequest) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        GetMessageListResponseType response;
        try {
            response = this.getConsultationService(token).getMessagesList(messagesListRequest);
            this.replyValidator.validateReplyStatus((ResponseType)response);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }

    @Override
    public ResponseType moveMessage(SAMLToken token, MoveMessageRequest messageRequestType) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        ResponseType response;
        try {
            response = this.getConsultationService(token).moveMessage(messageRequestType);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus(response);
        return response;
    }

    @Override
    public GetMessageAcknowledgmentsStatusResponse getMessageAcknowledgmentsStatusResponse(SAMLToken token, GetMessageAcknowledgmentsStatusRequest messageAcknowledgmentsStatusRequest) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        GetMessageAcknowledgmentsStatusResponse response;
        try {
            response = this.getConsultationService(token).getMessageAcknowledgmentsStatus(messageAcknowledgmentsStatusRequest);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }

    @Override
    public DeleteMessageResponse deleteMessage(SAMLToken token, DeleteMessageRequest request) throws SessionManagementException, TechnicalConnectorException, EhboxBusinessConnectorException {
        DeleteMessageResponse response;
        try {
            response = this.getConsultationService(token).deleteMessage(request);
        }
        catch (BusinessError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            LOG.debug(BEGINNINGTAB + MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()));
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }
}

